/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.limit;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.limit.Limitation;
import com.craftaro.skyblock.limit.impl.BlockLimitation;
import com.craftaro.skyblock.limit.impl.EntityLimitation;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public final class LimitationInstanceHandler {
    private final Map<Class<? extends Limitation>, Limitation> instances = new HashMap<Class<? extends Limitation>, Limitation>();
    private boolean loadChunks;

    public LimitationInstanceHandler() {
        this.registerInstance(new EntityLimitation(this));
        this.registerInstance(new BlockLimitation());
        this.reloadAll();
    }

    public boolean isLoadChunks() {
        return this.loadChunks;
    }

    public <T extends Limitation> T getInstance(Class<T> type) {
        return (T)((Limitation)type.cast(this.instances.get(type)));
    }

    public void registerInstance(Limitation instance) {
        this.instances.put(instance.getClass(), instance);
    }

    public void reloadAll() {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        FileConfiguration config = plugin.getLimits();
        this.loadChunks = plugin.getConfiguration().getBoolean("Island.Limits.LoadChunks");
        for (Limitation limit : this.instances.values()) {
            limit.reload(config.getConfigurationSection(limit.getSectionName()));
        }
    }
}

