/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.limit;

import com.craftaro.skyblock.limit.Limitation;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public abstract class EnumLimitation<K extends Enum<K>>
implements Limitation {
    private long defaultLimit = -1L;
    private final Class<K> type;
    private final Map<K, Long> map;

    public EnumLimitation(Class<K> type) {
        this.map = new EnumMap<K, Long>(type);
        this.type = type;
    }

    public boolean isBeingTracked(Enum<K> type) {
        return this.map.containsKey(type) || this.getDefault() >= 0L;
    }

    protected Map<K, Long> getMap() {
        return this.map;
    }

    public long getDefault() {
        return this.defaultLimit;
    }

    public boolean hasTooMuch(long currentAmount, Enum<K> type) {
        long cached = this.map.getOrDefault(type, this.getDefault());
        return cached > -1L && currentAmount > cached;
    }

    @Override
    public void reload(ConfigurationSection loadFrom) {
        this.unload();
        if (loadFrom == null) {
            return;
        }
        Set keys = loadFrom.getKeys(false);
        this.removeAndLoadDefaultLimit(loadFrom, keys);
        for (String key : keys) {
            String enumName = key.toUpperCase(Locale.ENGLISH);
            try {
                this.map.put(Enum.valueOf(this.type, enumName), loadFrom.getLong(key));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Incorrect enum constant '" + enumName + "' in " + loadFrom.getCurrentPath(), ex);
            }
        }
    }

    @Override
    public void unload() {
        this.map.clear();
        this.defaultLimit = -1L;
    }

    protected void removeAndLoadDefaultLimit(ConfigurationSection loadFrom, Set<String> keys) {
        keys.remove("DefaultLimit");
        this.defaultLimit = loadFrom.getInt("DefaultLimit", -1);
    }
}

