/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.levelling;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.island.IslandLevelChangeEvent;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.levelling.IslandScan;
import com.craftaro.skyblock.levelling.amount.BlockAmount;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class QueuedIslandScan {
    private final SkyBlock plugin;
    private final Island island;
    private IslandScan currentScan = null;
    private final Queue<IslandWorld> toScan = new LinkedList<IslandWorld>();
    private static final NumberFormat FORMATTER = NumberFormat.getInstance();
    private final Configuration language;
    private int executions;
    private final int runEveryX;
    private final Map<XMaterial, BlockAmount> amounts = new EnumMap<XMaterial, BlockAmount>(XMaterial.class);
    private int totalScanned;
    private int blocksSize;

    public QueuedIslandScan(SkyBlock plugin, Island island) {
        this.plugin = plugin;
        this.island = island;
        this.language = plugin.getLanguage();
        this.runEveryX = this.language.getInt("Command.Island.Level.Scanning.Progress.Display-Every-X-Scan");
    }

    public void addToScan(IslandWorld world) {
        this.toScan.add(world);
    }

    public void update() {
        this.executions += this.currentScan.getExecutions();
        this.totalScanned += this.currentScan.getTotalScanned();
        this.blocksSize += this.currentScan.getBlocksSize();
        for (Map.Entry<XMaterial, BlockAmount> entry : this.currentScan.getAmounts().entrySet()) {
            if (this.amounts.containsKey(entry.getKey())) {
                this.amounts.get(entry.getKey()).increaseAmount(entry.getValue().getAmount());
                continue;
            }
            this.amounts.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean scan() {
        if (this.currentScan != null) {
            this.update();
        }
        if (this.toScan.isEmpty()) {
            this.finalizeScan();
            return false;
        }
        IslandWorld world = this.toScan.poll();
        this.currentScan = new IslandScan(this.plugin, this.island, world).start();
        return true;
    }

    public void finalizeScan() {
        HashMap<String, Long> materials = new HashMap<String, Long>(this.amounts.size());
        for (Map.Entry<XMaterial, BlockAmount> entry : this.amounts.entrySet()) {
            materials.put(entry.getKey().name(), entry.getValue().getAmount());
        }
        IslandLevel level = this.island.getLevel();
        level.setMaterials(materials);
        level.setLastCalculatedLevel(level.getLevel());
        level.setLastCalculatedPoints(level.getPoints());
        Bukkit.getServer().getPluginManager().callEvent((Event)new IslandLevelChangeEvent(this.island.getAPIWrapper(), this.island.getAPIWrapper().getLevel()));
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.language.getBoolean("Command.Island.Level.Scanning.Progress.Should-Display-Message") && this.executions == 1 || this.totalScanned == this.blocksSize || this.executions % this.runEveryX == 0) {
                double percent = (double)this.totalScanned / (double)this.blocksSize * 100.0;
                if (Double.isNaN(percent)) {
                    percent = 0.0;
                }
                String message = this.language.getString("Command.Island.Level.Scanning.Progress.Message");
                message = message.replace("%current_scanned_blocks%", String.valueOf(this.totalScanned));
                message = message.replace("%max_blocks%", String.valueOf(this.blocksSize));
                message = message.replace("%percent_whole%", String.valueOf((int)percent));
                message = message.replace("%percent%", FORMATTER.format(percent));
                boolean displayComplete = this.totalScanned == this.blocksSize && this.language.getBoolean("Command.Island.Level.Scanning.Finished.Should-Display-Message");
                MessageManager messageManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getMessageManager();
                for (Player player : ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getPlayersAtIsland(this.island)) {
                    messageManager.sendMessage((CommandSender)player, message);
                    if (displayComplete) {
                        messageManager.sendMessage((CommandSender)player, this.language.getString("Command.Island.Level.Scanning.Finished.Message"));
                    }
                    this.island.getLevel().checkLevelUp();
                }
            }
        });
    }
}

