/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.levelling;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.blockscanner.BlockInfo;
import com.craftaro.skyblock.blockscanner.BlockScanner;
import com.craftaro.skyblock.blockscanner.CachedChunk;
import com.craftaro.skyblock.blockscanner.ChunkLoader;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.levelling.amount.AmountMaterialPair;
import com.craftaro.skyblock.levelling.amount.BlockAmount;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class IslandScan
extends BukkitRunnable {
    private final Set<Location> doubleBlocks;
    private final Island island;
    private final IslandWorld world;
    private final Map<XMaterial, BlockAmount> amounts;
    private final SkyBlock plugin;
    private int totalScanned;
    private int blocksSize;
    private Queue<BlockInfo> blocks;
    private int executions;

    public IslandScan(SkyBlock plugin, Island island, IslandWorld world) {
        if (island == null) {
            throw new IllegalArgumentException("island cannot be null");
        }
        this.plugin = plugin;
        this.island = island;
        this.world = world;
        this.amounts = new EnumMap<XMaterial, BlockAmount>(XMaterial.class);
        this.doubleBlocks = new HashSet<Location>();
    }

    public IslandScan start() {
        if (this.plugin.isPaperAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::initScan);
        } else {
            this.initScan();
        }
        return this;
    }

    private void initScan() {
        HashMap<World, List<CachedChunk>> cachedChunk = new HashMap<World, List<CachedChunk>>(3);
        this.populate(cachedChunk, this.plugin.isPaperAsync(), () -> BlockScanner.startScanner(cachedChunk, this.island, true, true, true, false, blocks -> {
            this.blocks = blocks;
            this.blocksSize = blocks.size();
            this.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        }));
    }

    public void run() {
        ++this.executions;
        int scanned = 0;
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            BlockInfo info = (BlockInfo)it.next();
            if (scanned == 8500) break;
            AmountMaterialPair pair = this.plugin.getLevellingManager().getAmountAndType(this, info);
            if (pair.getType() != null) {
                BlockAmount cachedAmount = this.amounts.get(pair.getType());
                if (cachedAmount == null) {
                    cachedAmount = new BlockAmount(pair.getAmount());
                } else {
                    cachedAmount.increaseAmount(pair.getAmount());
                }
                this.amounts.put(pair.getType(), cachedAmount);
            }
            ++scanned;
            it.remove();
        }
        this.totalScanned += scanned;
        if (this.blocks.isEmpty()) {
            this.cancel();
            this.plugin.getLevellingManager().stopScan(this.island);
        }
    }

    private void populate(Map<World, List<CachedChunk>> cachedChunks, boolean paper, PopulateTask task) {
        LinkedList positions = new LinkedList();
        ChunkLoader.startChunkLoadingPerChunk(this.island, this.world, paper, positions::add, value -> {
            cachedChunks.put(this.plugin.getWorldManager().getWorld(this.world), positions);
            task.onComplete();
        });
    }

    public Set<Location> getDoubleBlocks() {
        return this.doubleBlocks;
    }

    public Map<XMaterial, BlockAmount> getAmounts() {
        return Collections.unmodifiableMap(this.amounts);
    }

    public int getTotalScanned() {
        return this.totalScanned;
    }

    public int getBlocksSize() {
        return this.blocksSize;
    }

    public int getExecutions() {
        return this.executions;
    }

    private static interface PopulateTask {
        public void onComplete();
    }
}

