/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.levelling;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.blockscanner.BlockInfo;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.levelling.IslandScan;
import com.craftaro.skyblock.levelling.LevellingMaterial;
import com.craftaro.skyblock.levelling.QueuedIslandScan;
import com.craftaro.skyblock.levelling.amount.AmountMaterialPair;
import com.craftaro.skyblock.levelling.calculator.Calculator;
import com.craftaro.skyblock.levelling.calculator.CalculatorRegistry;
import com.craftaro.skyblock.levelling.calculator.impl.EpicSpawnerCalculator;
import com.craftaro.skyblock.levelling.calculator.impl.UltimateStackerCalculator;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.stackable.StackableManager;
import com.craftaro.skyblock.utils.MaterialUtils;
import com.craftaro.skyblock.utils.version.CompatibleSpawners;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class IslandLevelManager {
    private final Map<Island, QueuedIslandScan> inScan;
    private final Map<XMaterial, Double> worth;
    private final Map<XMaterial, AmountMaterialPair> cachedPairs;
    private final SkyBlock plugin;
    private static final AmountMaterialPair EMPTY = new AmountMaterialPair(null, 0L);

    public IslandLevelManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.inScan = new HashMap<Island, QueuedIslandScan>();
        this.worth = new EnumMap<XMaterial, Double>(XMaterial.class);
        this.cachedPairs = new EnumMap<XMaterial, AmountMaterialPair>(XMaterial.class);
        this.registerCalculators();
        this.reloadWorth();
    }

    public void startScan(Player attemptScanner, Island island) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.startScan(attemptScanner, island));
            return;
        }
        if (island == null) {
            throw new IllegalArgumentException("island cannot be null");
        }
        FileConfiguration config = this.plugin.getLanguage();
        MessageManager messageManager = this.plugin.getMessageManager();
        if (this.inScan.containsKey(island)) {
            if (attemptScanner != null) {
                messageManager.sendMessage((CommandSender)attemptScanner, config.getString("Command.Island.Level.Scanning.InScan.Message"));
            }
            return;
        }
        if (attemptScanner != null) {
            if (this.plugin.getIslandManager().getIslandPlayerAt(attemptScanner) != island) {
                messageManager.sendMessage((CommandSender)attemptScanner, config.getString("Command.Island.Level.Scanning.NotOnIsland.Message"));
                return;
            }
            messageManager.sendMessage((CommandSender)attemptScanner, config.getString("Command.Island.Level.Scanning.Started.Message"));
        }
        QueuedIslandScan queuedIslandScan = new QueuedIslandScan(this.plugin, island);
        queuedIslandScan.addToScan(IslandWorld.NORMAL);
        if (island.isRegionUnlocked(null, IslandWorld.NETHER)) {
            queuedIslandScan.addToScan(IslandWorld.NETHER);
        }
        if (island.isRegionUnlocked(null, IslandWorld.END)) {
            queuedIslandScan.addToScan(IslandWorld.END);
        }
        queuedIslandScan.scan();
        this.inScan.put(island, queuedIslandScan);
    }

    public boolean isScanning(Island island) {
        return this.inScan.containsKey(island);
    }

    void stopScan(Island island) {
        QueuedIslandScan queuedIslandScan = this.inScan.get(island);
        if (queuedIslandScan == null) {
            return;
        }
        if (!queuedIslandScan.scan()) {
            this.inScan.remove(island);
        }
    }

    public void reloadWorth() {
        this.worth.clear();
        FileConfiguration config = this.plugin.getLevelling();
        ConfigurationSection materialSection = config.getConfigurationSection("Materials");
        if (materialSection == null) {
            return;
        }
        for (String key : materialSection.getKeys(false)) {
            ConfigurationSection current = materialSection.getConfigurationSection(key);
            Optional<XMaterial> material = CompatibleMaterial.getMaterial(key);
            if (!material.isPresent()) continue;
            this.worth.put(material.get(), current.getDouble("Points", 0.0));
        }
    }

    public void addWorth(XMaterial material, double points) {
        this.worth.put(material, points);
    }

    public void removeWorth(XMaterial material) {
        this.worth.remove(material);
    }

    public List<LevellingMaterial> getWorthsAsLevelingMaterials() {
        ArrayList<LevellingMaterial> materials = new ArrayList<LevellingMaterial>(this.worth.size());
        for (Map.Entry<XMaterial, Double> entry : this.worth.entrySet()) {
            materials.add(new LevellingMaterial(entry.getKey(), entry.getValue()));
        }
        return materials;
    }

    public Map<XMaterial, Double> getWorths() {
        return this.worth;
    }

    public double getWorth(XMaterial material) {
        return this.worth.getOrDefault(material, 0.0);
    }

    public boolean hasWorth(XMaterial material) {
        return this.worth.containsKey(material);
    }

    private void registerCalculators() {
        XMaterial spawner = XMaterial.SPAWNER;
        PluginManager pm = Bukkit.getPluginManager();
        if (pm.isPluginEnabled("EpicSpawners")) {
            CalculatorRegistry.registerCalculator(new EpicSpawnerCalculator(), spawner);
        }
        if (pm.isPluginEnabled("UltimateStacker")) {
            CalculatorRegistry.registerCalculator(new UltimateStackerCalculator(), spawner);
        }
    }

    AmountMaterialPair getAmountAndType(IslandScan scan, BlockInfo info) {
        long stackSize;
        Block block = info.getWorld().getBlockAt(info.getX(), info.getY(), info.getZ());
        Optional<XMaterial> blockType = CompatibleMaterial.getMaterial(block.getType());
        if (!blockType.isPresent() || CompatibleMaterial.isAir(blockType.get())) {
            return EMPTY;
        }
        Optional<XMaterial> compMaterial = CompatibleMaterial.getMaterial(block.getType());
        if (!compMaterial.isPresent()) {
            return EMPTY;
        }
        Location blockLocation = block.getLocation();
        if (scan.getDoubleBlocks().contains(blockLocation)) {
            return EMPTY;
        }
        if (MaterialUtils.isTall(compMaterial.orElse(XMaterial.STONE))) {
            Block belowBlock = block.getRelative(BlockFace.DOWN);
            XMaterial belowMaterial = CompatibleMaterial.getMaterial(belowBlock.getType()).get();
            if (MaterialUtils.isTall(belowMaterial)) {
                block = belowBlock;
                blockType = Optional.of(belowMaterial);
                scan.getDoubleBlocks().add(belowBlock.getLocation());
            } else {
                scan.getDoubleBlocks().add(block.getRelative(BlockFace.UP).getLocation());
            }
        }
        List<Calculator> calculators = CalculatorRegistry.getCalculators(blockType.get());
        StackableManager stackableManager = this.plugin.getStackableManager();
        long l = stackSize = stackableManager == null ? 0L : stackableManager.getStackSizeOf(blockLocation, compMaterial.get());
        if (calculators == null) {
            if (stackSize > 1L) {
                return new AmountMaterialPair(compMaterial.get(), stackSize);
            }
            AmountMaterialPair cachedPair = this.cachedPairs.get(compMaterial);
            if (cachedPair != null) {
                return cachedPair;
            }
            cachedPair = new AmountMaterialPair(compMaterial.get(), 1L);
            this.cachedPairs.put(compMaterial.get(), cachedPair);
            return cachedPair;
        }
        long amount = 0L;
        for (Calculator calc : calculators) {
            amount += calc.getAmount(block);
        }
        if (amount == 0L) {
            amount = 1L;
        }
        return new AmountMaterialPair(compMaterial.get(), amount + stackSize);
    }

    public void updateLevel(Island island, Location location) {
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateLevelLocation(island, location));
        } else {
            this.updateLevelLocation(island, location);
        }
    }

    private void updateLevelLocation(Island island, Location location) {
        Block block = location.getBlock();
        XMaterial material = null;
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (block.getType().toString().toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER;
                }
            }
        }
        if (material == null) {
            material = CompatibleMaterial.getMaterial(block.getType()).orElse(null);
        }
        if (material == null || material == XMaterial.AIR) {
            return;
        }
        if (material == XMaterial.SPAWNER) {
            if (Bukkit.getPluginManager().isPluginEnabled("EpicSpawners") || Bukkit.getPluginManager().isPluginEnabled("UltimateStacker") || Bukkit.getPluginManager().isPluginEnabled("WildStacker")) {
                return;
            }
            CompatibleSpawners spawner = CompatibleSpawners.getSpawner(((CreatureSpawner)block.getState()).getSpawnedType());
            if (spawner != null) {
                material = CompatibleMaterial.getMaterial(spawner.getMaterial()).orElse(null);
            }
        }
        long materialAmount = 0L;
        IslandLevel level = island.getLevel();
        if (level.hasMaterial(material.name())) {
            materialAmount = level.getMaterialAmount(material.name());
        }
        level.setMaterialAmount(material.name(), materialAmount + 1L);
    }
}

