/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.leaderboard;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.leaderboard.Leaderboard;
import com.craftaro.skyblock.leaderboard.LeaderboardPlayer;
import com.craftaro.skyblock.leaderboard.LeaderboardTask;
import com.craftaro.skyblock.utils.VaultPermissions;
import com.craftaro.skyblock.visit.Visit;
import com.craftaro.skyblock.visit.VisitManager;
import com.craftaro.skyblock.world.WorldManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LeaderboardManager {
    private final SkyBlock plugin;
    private final List<Leaderboard> leaderboardStorage = new ArrayList<Leaderboard>();

    public LeaderboardManager(SkyBlock plugin) {
        this.plugin = plugin;
        new LeaderboardTask(plugin).runTaskTimerAsynchronously((Plugin)plugin, 0L, this.plugin.getConfiguration().getInt("Island.Leaderboard.Reset.Time") * 20);
        this.resetLeaderboard();
    }

    public void resetLeaderboard() {
        VisitManager visitManager = this.plugin.getVisitManager();
        WorldManager worldManager = this.plugin.getWorldManager();
        visitManager.loadIslands();
        int arraySize = visitManager.getIslands().size();
        ArrayList<LeaderboardPlayer> islandLevels = new ArrayList<LeaderboardPlayer>(arraySize);
        ArrayList<LeaderboardPlayer> islandBanks = new ArrayList<LeaderboardPlayer>(arraySize);
        ArrayList<LeaderboardPlayer> islandVotes = new ArrayList<LeaderboardPlayer>(arraySize);
        boolean enableExemptions = this.plugin.getConfiguration().getBoolean("Island.Leaderboard.Exemptions.Enable");
        for (UUID ownerUUID : new LinkedHashSet<UUID>(visitManager.getIslands().keySet())) {
            if (enableExemptions && VaultPermissions.hasPermission(worldManager.getWorld(IslandWorld.NORMAL).getName(), Bukkit.getOfflinePlayer((UUID)ownerUUID), "fabledskyblock.top.exempt")) continue;
            Visit visit = visitManager.getIslands().get(ownerUUID);
            islandLevels.add(new LeaderboardPlayer(ownerUUID, visit.getLevel().getLevel()));
            islandBanks.add(new LeaderboardPlayer(ownerUUID, (long)visit.getBankBalance()));
            islandVotes.add(new LeaderboardPlayer(ownerUUID, visit.getVoters().size()));
        }
        islandLevels.sort(Comparator.comparingLong(LeaderboardPlayer::getValue).reversed());
        islandBanks.sort(Comparator.comparingLong(LeaderboardPlayer::getValue).reversed());
        islandVotes.sort(Comparator.comparingLong(LeaderboardPlayer::getValue).reversed());
        for (int i = 0; i < 10; ++i) {
            Leaderboard leaderboard;
            if (!islandVotes.isEmpty() && i < islandVotes.size()) {
                leaderboard = new Leaderboard(Leaderboard.Type.VOTES, visitManager.getIsland(((LeaderboardPlayer)islandVotes.get(i)).getUUID()), i);
                this.leaderboardStorage.add(leaderboard);
            }
            if (!islandBanks.isEmpty() && i < islandBanks.size()) {
                leaderboard = new Leaderboard(Leaderboard.Type.BANK, visitManager.getIsland(((LeaderboardPlayer)islandBanks.get(i)).getUUID()), i);
                this.leaderboardStorage.add(leaderboard);
            }
            if (islandLevels.isEmpty() || i >= islandLevels.size()) continue;
            leaderboard = new Leaderboard(Leaderboard.Type.LEVEL, visitManager.getIsland(((LeaderboardPlayer)islandLevels.get(i)).getUUID()), i);
            this.leaderboardStorage.add(leaderboard);
        }
    }

    public int getPlayerIslandLeaderboardPosition(OfflinePlayer offlinePlayer, Leaderboard.Type type) {
        VisitManager visitManager = this.plugin.getVisitManager();
        visitManager.loadIslands();
        ArrayList<LeaderboardPlayer> leaderboardPlayers = new ArrayList<LeaderboardPlayer>(visitManager.getIslands().size());
        switch (type) {
            case LEVEL: {
                Visit visit;
                for (UUID ownerUUID : visitManager.getIslands().keySet()) {
                    visit = visitManager.getIslands().get(ownerUUID);
                    leaderboardPlayers.add(new LeaderboardPlayer(ownerUUID, visit.getLevel().getLevel()));
                }
                break;
            }
            case BANK: {
                Visit visit;
                for (UUID ownerUUID : visitManager.getIslands().keySet()) {
                    visit = visitManager.getIslands().get(ownerUUID);
                    leaderboardPlayers.add(new LeaderboardPlayer(ownerUUID, (long)visit.getBankBalance()));
                }
            }
            case VOTES: {
                Visit visit;
                for (UUID ownerUUID : visitManager.getIslands().keySet()) {
                    visit = visitManager.getIslands().get(ownerUUID);
                    leaderboardPlayers.add(new LeaderboardPlayer(ownerUUID, visit.getVoters().size()));
                }
                break;
            }
        }
        leaderboardPlayers.sort(Comparator.comparingLong(LeaderboardPlayer::getValue).reversed());
        for (int i = 0; i < leaderboardPlayers.size(); ++i) {
            if (!((LeaderboardPlayer)leaderboardPlayers.get(i)).getUUID().equals(offlinePlayer.getUniqueId())) continue;
            return i + 1;
        }
        return -1;
    }

    public void clearLeaderboard() {
        this.leaderboardStorage.clear();
    }

    public List<Leaderboard> getLeaderboard(Leaderboard.Type type) {
        ArrayList<Leaderboard> leaderboardIslands = new ArrayList<Leaderboard>();
        for (Leaderboard leaderboardList : this.leaderboardStorage) {
            if (leaderboardList.getType() != type) continue;
            leaderboardIslands.add(leaderboardList);
        }
        return leaderboardIslands;
    }

    public Leaderboard getLeaderboardFromPosition(Leaderboard.Type type, int position) {
        for (Leaderboard leaderboardPlayerList : this.leaderboardStorage) {
            if (leaderboardPlayerList.getType() != type || leaderboardPlayerList.getPosition() != position) continue;
            return leaderboardPlayerList;
        }
        return null;
    }

    public List<Leaderboard> getLeaderboards() {
        return this.leaderboardStorage;
    }
}

