/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.island.reward;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.reward.LevelReward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class RewardManager {
    private final SkyBlock skyBlock;
    private final Map<Long, LevelReward> registeredRewards = new HashMap<Long, LevelReward>();
    private final Map<Long, LevelReward> repeatRewards = new HashMap<Long, LevelReward>();

    public RewardManager(SkyBlock skyBlock) {
        this.skyBlock = skyBlock;
    }

    public void loadRewards() {
        ConfigurationSection repeatSection;
        FileConfiguration configLoad = this.skyBlock.getRewards();
        this.registeredRewards.clear();
        this.repeatRewards.clear();
        ConfigurationSection onceSection = configLoad.getConfigurationSection("Once");
        if (onceSection != null) {
            for (String key : onceSection.getKeys(false)) {
                long level;
                try {
                    level = Long.parseLong(key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.registeredRewards.put(level, this.loadReward("Once." + key));
            }
        }
        if ((repeatSection = configLoad.getConfigurationSection("Repeat")) != null) {
            for (String key : repeatSection.getKeys(false)) {
                long level;
                try {
                    level = Long.parseLong(key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.repeatRewards.put(level, this.loadReward("Repeat." + key));
            }
        }
    }

    private LevelReward loadReward(String path) {
        FileConfiguration config = this.skyBlock.getRewards();
        ConfigurationSection section = config.getConfigurationSection(path);
        LevelReward levelReward = new LevelReward();
        if (section == null) {
            return levelReward;
        }
        double money = section.getDouble("money", 0.0);
        levelReward.setMoney(money);
        double islandVault = section.getDouble("island-balance", 0.0);
        levelReward.setIslandBalance(islandVault);
        ArrayList<String> commands = section.contains("commands") ? section.getStringList("commands") : new ArrayList();
        levelReward.setCommands(commands);
        return levelReward;
    }

    public LevelReward getReward(long level) {
        return this.registeredRewards.getOrDefault(level, null);
    }

    public List<LevelReward> getRepeatRewards(long level) {
        ArrayList<LevelReward> levelRewards = new ArrayList<LevelReward>();
        for (long loopLevel : this.repeatRewards.keySet()) {
            if (level % loopLevel != 0L) continue;
            levelRewards.add(this.repeatRewards.get(loopLevel));
        }
        return levelRewards;
    }

    public Map<Long, LevelReward> getRegisteredRewards() {
        return Collections.unmodifiableMap(this.registeredRewards);
    }
}

