/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.island.removal;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.blockscanner.BlockInfo;
import com.craftaro.skyblock.blockscanner.BlockScanner;
import com.craftaro.skyblock.blockscanner.CachedChunk;
import com.craftaro.third_party.com.cryptomorin.xseries.XBlock;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkDeleteSplitter
extends BukkitRunnable {
    private final Map<World, List<CachedChunk>> cachedChunks;
    private Queue<BlockInfo> blocks;

    private ChunkDeleteSplitter(Map<World, List<CachedChunk>> cachedChunks) {
        this.cachedChunks = cachedChunks;
        this.start();
    }

    private void start() {
        BlockScanner.startScanner(this.cachedChunks, null, false, true, true, false, blocks -> {
            this.blocks = blocks;
            this.runTaskTimer((Plugin)SkyBlock.getPlugin(SkyBlock.class), 20L, 20L);
        });
    }

    public void run() {
        Iterator it = this.blocks.iterator();
        for (int deleteAmount = 0; it.hasNext() && deleteAmount != 3500; ++deleteAmount) {
            BlockInfo pair = (BlockInfo)it.next();
            Block block = pair.getWorld().getBlockAt(pair.getX(), pair.getY(), pair.getZ());
            XBlock.setType((Block)block, (XMaterial)XMaterial.AIR);
            it.remove();
        }
        if (this.blocks.isEmpty()) {
            this.cancel();
        }
    }

    public static void startDeletion(Map<World, List<CachedChunk>> snapshots) {
        new ChunkDeleteSplitter(snapshots);
    }
}

