/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.world.WorldManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;

public enum IslandWorld {
    NORMAL("Normal"),
    NETHER("Nether"),
    END("End");

    private final String friendlyName;

    private IslandWorld(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public static List<IslandWorld> getIslandWorlds() {
        ArrayList<IslandWorld> islandWorlds = new ArrayList<IslandWorld>(3);
        WorldManager worldManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getWorldManager();
        if (worldManager.getWorld(NORMAL) != null) {
            islandWorlds.add(NORMAL);
        }
        if (worldManager.getWorld(NETHER) != null) {
            islandWorlds.add(NETHER);
        }
        if (worldManager.getWorld(END) != null) {
            islandWorlds.add(END);
        }
        return islandWorlds;
    }

    public World.Environment getUncheckedEnvironment() {
        switch (this.ordinal()) {
            case 0: {
                return World.Environment.NORMAL;
            }
            case 1: {
                return World.Environment.NETHER;
            }
            case 2: {
                return World.Environment.THE_END;
            }
        }
        return null;
    }

    public World.Environment getEnvironment() {
        WorldManager worldManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getWorldManager();
        if (worldManager.getWorld(NORMAL) != null) {
            return World.Environment.NORMAL;
        }
        if (worldManager.getWorld(NETHER) != null) {
            return World.Environment.NETHER;
        }
        if (worldManager.getWorld(END) != null) {
            return World.Environment.THE_END;
        }
        return null;
    }
}

