/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.reward.LevelReward;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class IslandLevel {
    private final SkyBlock plugin;
    private UUID ownerUUID;
    private long lastCalculatedLevel = 0L;
    private double lastCalculatedPoints = 0.0;
    private Map<String, Long> materials;
    private long highestLevel;

    public IslandLevel(UUID ownerUUID, SkyBlock plugin) {
        HashMap<String, Long> materials;
        this.plugin = plugin;
        this.ownerUUID = ownerUUID;
        FileManager.Config config = plugin.getFileManager().getConfig(new File(new File(plugin.getDataFolder(), "level-data"), ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        ConfigurationSection section = configLoad.getConfigurationSection("Levelling.Materials");
        if (section != null) {
            Set keys = section.getKeys(false);
            materials = new HashMap(keys.size());
            for (String material : keys) {
                ConfigurationSection current = section.getConfigurationSection(material);
                if (!current.isSet("Amount")) continue;
                materials.put(material, current.getLong("Amount"));
            }
        } else {
            materials = new HashMap<String, Long>();
        }
        this.materials = materials;
        this.highestLevel = configLoad.contains("Levelling.Highest-Level") ? configLoad.getLong("Levelling.Highest-Level") : this.getLevel();
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public double getPoints() {
        FileConfiguration configLoad = this.plugin.getLevelling();
        ConfigurationSection materialSection = configLoad.getConfigurationSection("Materials");
        if (materialSection == null) {
            return 0.0;
        }
        double pointsEarned = 0.0;
        for (Map.Entry<String, Long> entry : this.materials.entrySet()) {
            ConfigurationSection current = materialSection.getConfigurationSection(entry.getKey());
            if (current == null) continue;
            double pointsRequired = current.getDouble("Points", 0.0);
            long blockAmount = entry.getValue();
            long materialLimit = current.getLong("Limit", -1L);
            long materialAmountCounted = Math.min(materialLimit, blockAmount);
            if (materialLimit == -1L) {
                materialAmountCounted = blockAmount;
            }
            if (pointsRequired == 0.0) continue;
            pointsEarned += (double)materialAmountCounted * pointsRequired;
        }
        return pointsEarned;
    }

    public long getMaterialPoints(String material) {
        long pointsRequired;
        FileConfiguration configLoad;
        ConfigurationSection materialSection;
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (material.toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER.name();
                }
            }
        }
        if ((materialSection = (configLoad = this.plugin.getLevelling()).getConfigurationSection("Materials")) == null) {
            return 0L;
        }
        ConfigurationSection current = materialSection.getConfigurationSection(material);
        if (current == null) {
            return 0L;
        }
        Long boxedAmount = this.materials.get(material);
        if (boxedAmount == null) {
            return 0L;
        }
        long materialLimit = current.getLong("Limit", -1L);
        long materialAmountCounted = Math.min(materialLimit, boxedAmount);
        if (materialLimit == -1L) {
            materialAmountCounted = boxedAmount;
        }
        return (pointsRequired = current.getLong("Points")) == 0L ? 0L : materialAmountCounted * pointsRequired;
    }

    public long getLevel() {
        long subtract;
        double points;
        long division = this.plugin.getConfiguration().getLong("Island.Levelling.Division");
        if (division == 0L) {
            division = 1L;
        }
        points = (points = this.getPoints()) >= (double)(subtract = this.plugin.getConfiguration().getLong("Island.Levelling.Subtract")) ? (points -= (double)subtract) : 0.0;
        return Math.round(points) / division;
    }

    public void checkLevelUp() {
        long level = this.getLevel();
        if (level <= this.highestLevel) {
            return;
        }
        FileConfiguration language = this.plugin.getLanguage();
        FileConfiguration config = this.plugin.getConfiguration();
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)this.ownerUUID);
        if (owner.isOnline()) {
            String msg;
            Player player = owner.getPlayer();
            if (config.getBoolean("Island.LevelRewards.Rewards", false)) {
                int i = (int)this.highestLevel + 1;
                while ((long)i <= level) {
                    List<LevelReward> repeatRewards;
                    LevelReward levelReward = this.plugin.getRewardManager().getReward(i);
                    if (levelReward != null) {
                        levelReward.give(player, this.plugin, i);
                    }
                    if (!(repeatRewards = this.plugin.getRewardManager().getRepeatRewards(i)).isEmpty()) {
                        for (LevelReward reward : repeatRewards) {
                            reward.give(player, this.plugin, i);
                        }
                    }
                    ++i;
                }
            }
            if (config.getBoolean("Island.LevelRewards.Messages", false) && !Strings.isNullOrEmpty((String)(msg = language.getString("Command.Island.Level.LevelUp.Message")))) {
                msg = msg.replace("%level%", String.valueOf(level));
                this.plugin.getMessageManager().sendMessage((CommandSender)player, msg);
            }
        }
        this.setHighestLevel(level);
    }

    public void addMaterial(String material, long amount) {
        this.setMaterialAmount(material, this.getMaterialAmount(material) + amount);
    }

    public void setMaterialAmount(String material, long amount) {
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (material.toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER.name();
                }
            }
        }
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "level-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Levelling.Materials." + material + ".Amount", (Object)amount);
        this.materials.put(material, amount);
    }

    public long getMaterialAmount(String material) {
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (material.toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER.name();
                }
            }
        }
        return this.materials.getOrDefault(material, 0L);
    }

    public void removeMaterial(String material) {
        if (MajorServerVersion.isServerVersion(MajorServerVersion.V1_8)) {
            switch (material.toUpperCase()) {
                case "DIODE_BLOCK_OFF": 
                case "DIODE_BLOCK_ON": {
                    material = XMaterial.REPEATER.name();
                }
            }
        }
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "level-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Levelling.Materials." + material, null);
        this.materials.remove(material);
    }

    public boolean hasMaterial(String material) {
        return this.materials.containsKey(material);
    }

    public boolean hasMaterials() {
        return this.materials.size() != 0;
    }

    public Map<String, Long> getMaterials() {
        return this.materials;
    }

    public void setMaterials(Map<String, Long> materials) {
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "level-data"), this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        configLoad.set("Levelling.Materials", null);
        for (String materialList : materials.keySet()) {
            configLoad.set("Levelling.Materials." + materialList + ".Amount", (Object)materials.get(materialList));
        }
        this.materials = materials;
    }

    public double getLastCalculatedPoints() {
        return this.lastCalculatedPoints;
    }

    public void setLastCalculatedPoints(double lastCalculatedPoints) {
        this.lastCalculatedPoints = lastCalculatedPoints;
    }

    public long getLastCalculatedLevel() {
        return this.lastCalculatedLevel;
    }

    public void setLastCalculatedLevel(long lastCalculatedLevel) {
        this.lastCalculatedLevel = lastCalculatedLevel;
    }

    public void save() {
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "level-data"), this.ownerUUID.toString() + ".yml"));
        File configFile = config.getFile();
        FileConfiguration configLoad = config.getFileConfiguration();
        try {
            configLoad.save(configFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setHighestLevel(long highestLevel) {
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "level-data"), this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        configLoad.set("Levelling.Highest-Level", (Object)highestLevel);
        this.highestLevel = highestLevel;
    }
}

