/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.island.IslandBiomeChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandLocationChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandMessageChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandOpenEvent;
import com.craftaro.skyblock.api.event.island.IslandPasswordChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandRoleChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandStatusChangeEvent;
import com.craftaro.skyblock.api.event.island.IslandUpgradeEvent;
import com.craftaro.skyblock.api.event.island.IslandWeatherChangeEvent;
import com.craftaro.skyblock.api.utils.APIUtil;
import com.craftaro.skyblock.ban.Ban;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.CompatibleBiome;
import com.craftaro.skyblock.core.nms.world.NmsWorldBorder;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.core.utils.PlayerUtils;
import com.craftaro.skyblock.island.IslandCoop;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandLevel;
import com.craftaro.skyblock.island.IslandLocation;
import com.craftaro.skyblock.island.IslandMessage;
import com.craftaro.skyblock.island.IslandPermission;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.BasicPermission;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import com.craftaro.skyblock.upgrade.Upgrade;
import com.craftaro.skyblock.visit.Visit;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Island {
    private final SkyBlock plugin;
    private final com.craftaro.skyblock.api.island.Island apiWrapper;
    private final Map<IslandRole, List<IslandPermission>> islandPermissions = new HashMap<IslandRole, List<IslandPermission>>();
    private final List<IslandLocation> islandLocations = new ArrayList<IslandLocation>();
    private final Map<UUID, IslandCoop> coopPlayers = new HashMap<UUID, IslandCoop>();
    private final Set<UUID> whitelistedPlayers = new HashSet<UUID>();
    private final Map<IslandRole, Set<UUID>> roleCache = new HashMap<IslandRole, Set<UUID>>();
    private UUID islandUUID;
    private UUID ownerUUID;
    private final IslandLevel level;
    private IslandStatus status;
    private int size;
    private int maxMembers;
    private boolean deleted = false;

    public Island(@Nonnull OfflinePlayer player) {
        FileManager.Config coopDataConfig;
        FileConfiguration coopDataConfigLoad;
        File coopDataFile;
        FileConfiguration configLoad;
        int customSize;
        this.plugin = SkyBlock.getInstance();
        FileManager fileManager = this.plugin.getFileManager();
        this.islandUUID = UUID.randomUUID();
        this.ownerUUID = player.getUniqueId();
        this.size = this.plugin.getConfiguration().getInt("Island.Size.Minimum");
        this.maxMembers = this.plugin.getConfiguration().getInt("Island.Member.Capacity", 3);
        if (this.size > 1000) {
            this.size = 50;
        }
        if (player.isOnline() && ((customSize = PlayerUtils.getNumberFromPermission(player.getPlayer(), "fabledskyblock.size", 0)) > 0 || player.getPlayer().hasPermission("fabledskyblock.*"))) {
            FileConfiguration configLoad2 = this.plugin.getConfiguration();
            int minimumSize = configLoad2.getInt("Island.Size.Minimum");
            int maximumSize = configLoad2.getInt("Island.Size.Maximum");
            if (minimumSize < 0 || minimumSize > 1000) {
                minimumSize = 50;
            }
            if (maximumSize < 0 || maximumSize > 1000) {
                maximumSize = 100;
            }
            this.size = Math.max(minimumSize, Math.min(customSize, maximumSize));
        }
        this.level = new IslandLevel(this.getOwnerUUID(), this.plugin);
        File configFile = new File(this.plugin.getDataFolder() + "/island-data");
        FileManager.Config config = fileManager.getConfig(new File(configFile, this.ownerUUID + ".yml"));
        FileConfiguration mainConfigLoad = this.plugin.getConfiguration();
        if (fileManager.isFileExist(new File(configFile, this.ownerUUID + ".yml"))) {
            String open;
            FileConfiguration playerDataConfigLoad;
            FileManager.Config playerDataConfig;
            int i;
            configLoad = config.getFileConfiguration();
            if (configLoad.getString("UUID") != null) {
                this.islandUUID = FastUUID.parseUUID(configLoad.getString("UUID"));
            } else {
                configLoad.set("UUID", (Object)this.islandUUID.toString());
            }
            if (configLoad.getString("MaxMembers") != null) {
                this.maxMembers = configLoad.getInt("MaxMembers");
            } else {
                configLoad.set("MaxMembers", (Object)this.maxMembers);
            }
            if (configLoad.getString("Size") != null) {
                this.size = configLoad.getInt("Size");
            } else {
                configLoad.set("Size", (Object)this.size);
            }
            if (configLoad.getString("Settings") != null) {
                configLoad.set("Settings", null);
            }
            if (configLoad.getString("Levelling.Materials") != null) {
                configLoad.set("Levelling.Materials", null);
            }
            if (configLoad.getString("Border") == null) {
                configLoad.set("Border.Enable", (Object)mainConfigLoad.getBoolean("Island.WorldBorder.Default", false));
                configLoad.set("Border.Color", (Object)NmsWorldBorder.BorderColor.BLUE.name());
            }
            if (configLoad.getString("Members") != null) {
                List members = configLoad.getStringList("Members");
                for (i = 0; i < members.size(); ++i) {
                    String member = (String)members.get(i);
                    playerDataConfig = new FileManager.Config(fileManager, new File(this.plugin.getDataFolder().toString() + "/player-data", member + ".yml"));
                    playerDataConfigLoad = playerDataConfig.getFileConfiguration();
                    if (playerDataConfigLoad.getString("Island.Owner") != null && playerDataConfigLoad.getString("Island.Owner").equals(this.ownerUUID.toString())) continue;
                    members.remove(i);
                }
                configLoad.set("Members", (Object)members);
            }
            if (configLoad.getString("Operators") != null) {
                List operators = configLoad.getStringList("Operators");
                for (i = 0; i < operators.size(); ++i) {
                    Iterator operator = (String)operators.get(i);
                    playerDataConfig = new FileManager.Config(fileManager, new File(this.plugin.getDataFolder().toString() + "/player-data", (String)((Object)operator) + ".yml"));
                    playerDataConfigLoad = playerDataConfig.getFileConfiguration();
                    if (playerDataConfigLoad.getString("Island.Owner") != null && playerDataConfigLoad.getString("Island.Owner").equals(this.ownerUUID.toString())) continue;
                    operators.remove(i);
                }
                configLoad.set("Operators", (Object)operators);
            }
            Object settingsDataConfig = null;
            File settingDataFile = new File(this.plugin.getDataFolder() + "/setting-data", this.getOwnerUUID().toString() + ".yml");
            if (fileManager.isFileExist(settingDataFile)) {
                settingsDataConfig = fileManager.getConfig(settingDataFile);
            }
            for (IslandRole roleList : IslandRole.getRoles()) {
                List<BasicPermission> allPermissions = this.plugin.getPermissionManager().getPermissions();
                ArrayList<IslandPermission> permissions = new ArrayList<IslandPermission>(allPermissions.size());
                for (BasicPermission permission : allPermissions) {
                    if (settingsDataConfig == null || ((FileManager.Config)settingsDataConfig).getFileConfiguration().getString("Settings." + roleList.getFriendlyName().toUpperCase(Locale.US) + "." + permission.getName()) == null) {
                        permissions.add(new IslandPermission(permission, this.plugin.getSettings().getBoolean("Settings." + roleList.getFriendlyName().toUpperCase(Locale.US) + "." + permission.getName(), permission.getDefaultValues().get((Object)roleList).booleanValue())));
                        continue;
                    }
                    permissions.add(new IslandPermission(permission, ((FileManager.Config)settingsDataConfig).getFileConfiguration().getBoolean("Settings." + roleList.getFriendlyName().toUpperCase(Locale.US) + "." + permission.getName(), true)));
                }
                this.islandPermissions.put(roleList, permissions);
            }
            if (configLoad.getString("Whitelist") != null) {
                for (String whitelistedUUID : configLoad.getStringList("Whitelist")) {
                    this.whitelistedPlayers.add(FastUUID.parseUUID(whitelistedUUID));
                }
            }
            if ((open = configLoad.getString("Visitor.Open", null)) != null && (open.equalsIgnoreCase("true") || open.equalsIgnoreCase("false"))) {
                this.status = configLoad.getBoolean("Visitor.Open") ? IslandStatus.OPEN : IslandStatus.CLOSED;
                configLoad.set("Visitor.Open", null);
                configLoad.set("Visitor.Status", (Object)mainConfigLoad.getString("Island.Visitor.Status"));
            } else if (configLoad.getString("Visitor.Status") != null) {
                this.status = IslandStatus.getEnum(configLoad.getString("Visitor.Status"));
            } else {
                this.status = IslandStatus.WHITELISTED;
                configLoad.set("Visitor.Status", (Object)mainConfigLoad.getString("Island.Visitor.Status"));
            }
        } else {
            configLoad = config.getFileConfiguration();
            configLoad.set("UUID", (Object)this.islandUUID.toString());
            configLoad.set("Visitor.Status", (Object)mainConfigLoad.getString("Island.Visitor.Status").toUpperCase());
            configLoad.set("Border.Enable", (Object)mainConfigLoad.getBoolean("Island.WorldBorder.Default", false));
            configLoad.set("Border.Color", (Object)NmsWorldBorder.BorderColor.BLUE.name());
            configLoad.set("Biome.Type", (Object)mainConfigLoad.getString("Island.Biome.Default.Type").toUpperCase());
            configLoad.set("Weather.Synchronised", (Object)mainConfigLoad.getBoolean("Island.Weather.Default.Synchronised"));
            configLoad.set("Weather.Time", (Object)mainConfigLoad.getInt("Island.Weather.Default.Time"));
            configLoad.set("Weather.Weather", (Object)mainConfigLoad.getString("Island.Weather.Default.Weather").toUpperCase());
            configLoad.set("Ownership.Original", (Object)this.ownerUUID.toString());
            configLoad.set("Size", (Object)this.size);
            for (IslandRole roleList : IslandRole.getRoles()) {
                List<BasicPermission> allPermissions = this.plugin.getPermissionManager().getPermissions();
                ArrayList<IslandPermission> permissions = new ArrayList<IslandPermission>(allPermissions.size());
                for (BasicPermission permission : allPermissions) {
                    permissions.add(new IslandPermission(permission, this.plugin.getSettings().getBoolean("Settings." + roleList.getFriendlyName() + "." + permission.getName(), true)));
                }
                this.islandPermissions.put(roleList, permissions);
            }
            this.status = IslandStatus.getEnum(mainConfigLoad.getString("Island.Visitor.Status"));
            Player onlinePlayer = Bukkit.getServer().getPlayer(this.ownerUUID);
            if (!this.plugin.getPlayerDataManager().hasPlayerData(onlinePlayer)) {
                this.plugin.getPlayerDataManager().createPlayerData(onlinePlayer);
            }
            PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(onlinePlayer);
            playerData.setPlaytime(0);
            playerData.setOwner(this.ownerUUID);
            playerData.setMemberSince(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
            playerData.save();
        }
        if (!mainConfigLoad.getBoolean("Island.Coop.Unload") && fileManager.isFileExist(coopDataFile = new File(this.plugin.getDataFolder().toString() + "/coop-data", this.getOwnerUUID().toString() + ".yml")) && (coopDataConfigLoad = (coopDataConfig = fileManager.getConfig(coopDataFile)).getFileConfiguration()).getString("CoopPlayers") != null) {
            for (String coopPlayerList : coopDataConfigLoad.getStringList("CoopPlayers")) {
                this.coopPlayers.put(FastUUID.parseUUID(coopPlayerList), IslandCoop.NORMAL);
            }
        }
        this.save();
        this.apiWrapper = new com.craftaro.skyblock.api.island.Island(this, player);
    }

    public UUID getIslandUUID() {
        return this.islandUUID;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.getVisit().setOwnerUUID(uuid);
        this.ownerUUID = uuid;
    }

    public UUID getOriginalOwnerUUID() {
        return FastUUID.parseUUID(this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder().toString() + "/island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Ownership.Original"));
    }

    public int getMaxMembers(Player player) {
        try {
            return PlayerUtils.getNumberFromPermission(Objects.requireNonNull(player.getPlayer()), "fabledskyblock.members", this.maxMembers);
        }
        catch (Exception ignored) {
            return this.maxMembers;
        }
    }

    public void setMaxMembers(int maxMembers) {
        if (maxMembers > 100000 || maxMembers < 0) {
            maxMembers = 2;
        }
        this.maxMembers = maxMembers;
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("MaxMembers", (Object)maxMembers);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size > 1000 || size < 0) {
            size = 50;
        }
        this.size = size;
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Size", (Object)size);
    }

    public double getRadius() {
        return (this.size % 2 == 0 ? (double)this.size : (double)this.size - 1.0) / 2.0;
    }

    public boolean hasPassword() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Ownership.Password") != null;
    }

    public String getPassword() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Ownership.Password");
    }

    public void setPassword(String password) {
        IslandPasswordChangeEvent islandPasswordChangeEvent = new IslandPasswordChangeEvent(this.getAPIWrapper(), password);
        Bukkit.getServer().getPluginManager().callEvent((Event)islandPasswordChangeEvent);
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Ownership.Password", (Object)islandPasswordChangeEvent.getPassword());
    }

    public Location getLocation(IslandWorld world, IslandEnvironment environment) {
        for (IslandLocation islandLocationList : this.islandLocations) {
            if (!islandLocationList.getWorld().equals((Object)world) || !islandLocationList.getEnvironment().equals((Object)environment)) continue;
            return islandLocationList.getLocation();
        }
        return null;
    }

    public IslandLocation getIslandLocation(IslandWorld world, IslandEnvironment environment) {
        for (IslandLocation islandLocationList : this.islandLocations) {
            if (islandLocationList.getWorld() != world || islandLocationList.getEnvironment() != environment) continue;
            return islandLocationList;
        }
        return null;
    }

    public void addLocation(IslandWorld world, IslandEnvironment environment, Location location) {
        this.islandLocations.add(new IslandLocation(world, environment, location));
    }

    public void setLocation(IslandWorld world, IslandEnvironment environment, Location location) {
        for (IslandLocation islandLocationList : this.islandLocations) {
            if (islandLocationList.getWorld() != world || islandLocationList.getEnvironment() != environment) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getServer().getPluginManager().callEvent((Event)new IslandLocationChangeEvent(this.getAPIWrapper(), new com.craftaro.skyblock.api.island.IslandLocation(APIUtil.fromImplementation(environment), APIUtil.fromImplementation(world), location))));
            FileManager fileManager = this.plugin.getFileManager();
            if (environment == IslandEnvironment.ISLAND) {
                fileManager.setLocation(fileManager.getConfig(new File(new File(this.plugin.getDataFolder() + "/island-data"), this.getOwnerUUID().toString() + ".yml")), "Location." + world.getFriendlyName() + "." + environment.getFriendlyName(), location, true);
            } else {
                fileManager.setLocation(fileManager.getConfig(new File(new File(this.plugin.getDataFolder() + "/island-data"), this.getOwnerUUID().toString() + ".yml")), "Location." + world.getFriendlyName() + ".Spawn." + environment.getFriendlyName(), location, true);
            }
            islandLocationList.setLocation(location);
            break;
        }
    }

    public boolean isBorder() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getBoolean("Border.Enable");
    }

    public void setBorder(boolean border) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Border.Enable", (Object)border);
    }

    public NmsWorldBorder.BorderColor getBorderColor() {
        String colorString = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Border.Color");
        return NmsWorldBorder.BorderColor.valueOf(colorString.toUpperCase());
    }

    public void setBorderColor(NmsWorldBorder.BorderColor color) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Border.Color", (Object)color.name());
    }

    public boolean isInBorder(Location blockLocation) {
        WorldManager worldManager = this.plugin.getWorldManager();
        if (!this.isBorder()) {
            return true;
        }
        Location islandLocation = this.getLocation(worldManager.getIslandWorld(blockLocation.getWorld()), IslandEnvironment.ISLAND);
        double halfSize = Math.floor(this.getRadius());
        return !((double)blockLocation.getBlockX() > (double)islandLocation.getBlockX() + halfSize || (double)blockLocation.getBlockX() < (double)islandLocation.getBlockX() - halfSize - 1.0 || (double)blockLocation.getBlockZ() > (double)islandLocation.getBlockZ() + halfSize || (double)blockLocation.getBlockZ() < (double)islandLocation.getBlockZ() - halfSize - 1.0);
    }

    public Biome getBiome() {
        return CompatibleBiome.getBiome(this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Biome.Type")).getBiome();
    }

    public void setBiome(Biome biome) {
        IslandBiomeChangeEvent islandBiomeChangeEvent = new IslandBiomeChangeEvent(this.getAPIWrapper(), biome);
        Bukkit.getServer().getPluginManager().callEvent((Event)islandBiomeChangeEvent);
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Biome.Type", (Object)islandBiomeChangeEvent.getBiome().name());
    }

    public String getBiomeName() {
        return WordUtils.capitalizeFully(this.getBiome().name().replace("_", " "));
    }

    public boolean isWeatherSynchronized() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getBoolean("Weather.Synchronised");
    }

    public void setWeatherSynchronized(boolean sync) {
        IslandWeatherChangeEvent islandWeatherChangeEvent = new IslandWeatherChangeEvent(this.getAPIWrapper(), this.getWeather(), this.getTime(), sync);
        Bukkit.getServer().getPluginManager().callEvent((Event)islandWeatherChangeEvent);
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Weather.Synchronised", (Object)sync);
    }

    public WeatherType getWeather() {
        WeatherType weatherType;
        String weatherTypeName = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Weather.Weather");
        if (weatherTypeName == null || weatherTypeName.isEmpty()) {
            weatherType = WeatherType.CLEAR;
        } else {
            try {
                weatherType = WeatherType.valueOf((String)weatherTypeName);
            }
            catch (IllegalArgumentException e) {
                weatherType = WeatherType.CLEAR;
            }
        }
        return weatherType;
    }

    public void setWeather(WeatherType weatherType) {
        IslandWeatherChangeEvent islandWeatherChangeEvent = new IslandWeatherChangeEvent(this.getAPIWrapper(), weatherType, this.getTime(), this.isWeatherSynchronized());
        Bukkit.getServer().getPluginManager().callEvent((Event)islandWeatherChangeEvent);
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Weather.Weather", (Object)weatherType.name());
    }

    public String getWeatherName() {
        return WordUtils.capitalize(this.getWeather().name().toLowerCase());
    }

    public int getTime() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getInt("Weather.Time");
    }

    public void setTime(int time) {
        IslandWeatherChangeEvent islandWeatherChangeEvent = new IslandWeatherChangeEvent(this.getAPIWrapper(), this.getWeather(), time, this.isWeatherSynchronized());
        Bukkit.getServer().getPluginManager().callEvent((Event)islandWeatherChangeEvent);
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Weather.Time", (Object)time);
    }

    public Map<UUID, IslandCoop> getCoopPlayers() {
        return this.coopPlayers;
    }

    public void addCoopPlayer(UUID uuid, IslandCoop islandCoop) {
        this.coopPlayers.put(uuid, islandCoop);
        this.save();
    }

    public void removeCoopPlayer(UUID uuid) {
        this.coopPlayers.remove(uuid);
        this.save();
    }

    public boolean isCoopPlayer(UUID uuid) {
        return this.coopPlayers.containsKey(uuid);
    }

    public IslandCoop getCoopType(UUID uuid) {
        return this.coopPlayers.getOrDefault(uuid, null);
    }

    public void setAlwaysLoaded(boolean alwaysLoaded) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("AlwaysLoaded", (Object)alwaysLoaded);
    }

    public boolean isAlwaysLoaded() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getBoolean("AlwaysLoaded", false);
    }

    public Set<UUID> getRole(IslandRole role) {
        if (this.roleCache.containsKey((Object)role)) {
            return new HashSet<UUID>((Collection)this.roleCache.get((Object)role));
        }
        HashSet<UUID> islandRoles = new HashSet<UUID>();
        if (role == IslandRole.OWNER) {
            islandRoles.add(this.getOwnerUUID());
        } else {
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml"));
            FileConfiguration configLoad = config.getFileConfiguration();
            if (configLoad.getString(role.getFriendlyName() + "s") != null) {
                for (String playerList : configLoad.getStringList(role.getFriendlyName() + "s")) {
                    islandRoles.add(FastUUID.parseUUID(playerList));
                }
            }
        }
        this.roleCache.put(role, islandRoles);
        return islandRoles;
    }

    public IslandRole getRole(OfflinePlayer player) {
        if (this.isCoopPlayer(player.getUniqueId())) {
            return IslandRole.COOP;
        }
        for (IslandRole role : IslandRole.values()) {
            if (!this.getRole(role).contains(player.getUniqueId())) continue;
            return role;
        }
        return IslandRole.VISITOR;
    }

    public boolean setRole(IslandRole role, UUID uuid) {
        if (role != IslandRole.VISITOR && role != IslandRole.COOP && role != IslandRole.OWNER && !this.hasRole(role, uuid)) {
            if (role == IslandRole.MEMBER) {
                if (this.hasRole(IslandRole.OPERATOR, uuid)) {
                    Bukkit.getServer().getPluginManager().callEvent((Event)new IslandRoleChangeEvent(this.getAPIWrapper(), Bukkit.getServer().getOfflinePlayer(uuid), APIUtil.fromImplementation(role)));
                    this.removeRole(IslandRole.OPERATOR, uuid);
                }
            } else if (role == IslandRole.OPERATOR && this.hasRole(IslandRole.MEMBER, uuid)) {
                Bukkit.getServer().getPluginManager().callEvent((Event)new IslandRoleChangeEvent(this.getAPIWrapper(), Bukkit.getServer().getOfflinePlayer(uuid), APIUtil.fromImplementation(role)));
                this.removeRole(IslandRole.MEMBER, uuid);
            }
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.getOwnerUUID().toString() + ".yml"));
            File configFile = config.getFile();
            FileConfiguration configLoad = config.getFileConfiguration();
            List<String> islandMembers = configLoad.getString(role.getFriendlyName() + "s") == null ? new ArrayList<String>() : configLoad.getStringList(role.getFriendlyName() + "s");
            islandMembers.add(FastUUID.toString(uuid));
            configLoad.set(role.getFriendlyName() + "s", islandMembers);
            try {
                configLoad.save(configFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.getVisit().setMembers(this.getRole(IslandRole.MEMBER).size() + this.getRole(IslandRole.OPERATOR).size() + 1);
            this.roleCache.remove((Object)role);
            return true;
        }
        return false;
    }

    public boolean removeRole(IslandRole role, UUID uuid) {
        if (role != IslandRole.VISITOR && role != IslandRole.COOP && role != IslandRole.OWNER && this.hasRole(role, uuid)) {
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.getOwnerUUID().toString() + ".yml"));
            File configFile = config.getFile();
            FileConfiguration configLoad = config.getFileConfiguration();
            List islandMembers = configLoad.getStringList(role.getFriendlyName() + "s");
            islandMembers.remove(FastUUID.toString(uuid));
            configLoad.set(role.getFriendlyName() + "s", (Object)islandMembers);
            try {
                configLoad.save(configFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.getVisit().setMembers(this.getRole(IslandRole.MEMBER).size() + this.getRole(IslandRole.OPERATOR).size() + 1);
            this.roleCache.remove((Object)role);
            return true;
        }
        return false;
    }

    public boolean hasRole(IslandRole role, UUID uuid) {
        return this.getRole(role).contains(uuid) || this.plugin.getIslandManager().getPlayerProxyingAnotherPlayer(uuid) != null && this.getRole(role).contains(this.plugin.getIslandManager().getPlayerProxyingAnotherPlayer(uuid));
    }

    public void setUpgrade(Player player, Upgrade.Type type, boolean status) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Upgrade." + type.getFriendlyName(), (Object)status);
        Bukkit.getServer().getPluginManager().callEvent((Event)new IslandUpgradeEvent(this.getAPIWrapper(), player, APIUtil.fromImplementation(type)));
    }

    public void removeUpgrade(Upgrade.Type type) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Upgrade." + type.getFriendlyName(), null);
    }

    public boolean hasUpgrade(Upgrade.Type type) {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Upgrade." + type.getFriendlyName()) != null;
    }

    public boolean isUpgrade(Upgrade.Type type) {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getBoolean("Upgrade." + type.getFriendlyName());
    }

    public boolean hasPermission(IslandRole role, BasicPermission permission) {
        if (this.islandPermissions.containsKey((Object)role)) {
            for (IslandPermission islandPermission : this.islandPermissions.get((Object)role)) {
                if (!islandPermission.getPermission().equals(permission)) continue;
                return islandPermission.getStatus();
            }
        }
        return true;
    }

    public IslandPermission getPermission(IslandRole role, BasicPermission permission) {
        if (this.islandPermissions.containsKey((Object)role)) {
            for (IslandPermission islandPermission : this.islandPermissions.get((Object)role)) {
                if (islandPermission.getPermission() != permission) continue;
                return islandPermission;
            }
        }
        return null;
    }

    public List<IslandPermission> getSettings(IslandRole role) {
        if (this.islandPermissions.containsKey((Object)role)) {
            return Collections.unmodifiableList(this.islandPermissions.get((Object)role));
        }
        return Collections.emptyList();
    }

    public double getBankBalance() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getDouble("Bank.Balance");
    }

    public void addToBank(double value) {
        FileManager fileManager = this.plugin.getFileManager();
        FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder() + "/island-data", this.ownerUUID.toString() + ".yml"));
        value = this.getBankBalance() + value;
        config.getFileConfiguration().set("Bank.Balance", (Object)value);
        try {
            config.getFileConfiguration().save(config.getFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void removeFromBank(double value) {
        this.addToBank(-value);
    }

    public IslandStatus getStatus() {
        return this.status;
    }

    public void setStatus(IslandStatus status) {
        IslandOpenEvent islandOpenEvent = new IslandOpenEvent(this.getAPIWrapper(), status == IslandStatus.OPEN);
        Bukkit.getServer().getPluginManager().callEvent((Event)islandOpenEvent);
        if (islandOpenEvent.isCancelled()) {
            return;
        }
        IslandStatusChangeEvent islandStatusChangeEvent = new IslandStatusChangeEvent(this.getAPIWrapper(), APIUtil.fromImplementation(status));
        Bukkit.getServer().getPluginManager().callEvent((Event)islandStatusChangeEvent);
        if (!islandStatusChangeEvent.isCancelled()) {
            this.status = status;
            this.getVisit().setStatus(status);
            this.save();
        }
    }

    public List<String> getMessage(IslandMessage message) {
        List<String> islandMessage = new ArrayList<String>();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (configLoad.getString("Visitor." + message.getFriendlyName() + ".Message") != null) {
            islandMessage = configLoad.getStringList("Visitor." + message.getFriendlyName() + ".Message");
        }
        return islandMessage;
    }

    public String getMessageAuthor(IslandMessage message) {
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (configLoad.getString("Visitor." + message.getFriendlyName() + ".Author") != null) {
            return configLoad.getString("Visitor." + message.getFriendlyName() + ".Author");
        }
        return "";
    }

    public void setMessage(IslandMessage message, String author, List<String> lines) {
        IslandMessageChangeEvent islandMessageChangeEvent = new IslandMessageChangeEvent(this.getAPIWrapper(), APIUtil.fromImplementation(message), lines, author);
        Bukkit.getServer().getPluginManager().callEvent((Event)islandMessageChangeEvent);
        if (!islandMessageChangeEvent.isCancelled()) {
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml"));
            FileConfiguration configLoad = config.getFileConfiguration();
            configLoad.set("Visitor." + message.getFriendlyName() + ".Message", islandMessageChangeEvent.getLines());
            configLoad.set("Visitor." + message.getFriendlyName() + ".Author", (Object)islandMessageChangeEvent.getAuthor());
            if (message == IslandMessage.SIGNATURE) {
                this.getVisit().setSignature(lines);
            }
        }
    }

    public boolean hasStructure() {
        return this.getStructure() != null;
    }

    public String getStructure() {
        return this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().getString("Structure");
    }

    public void setStructure(String structure) {
        this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml")).getFileConfiguration().set("Structure", (Object)structure);
    }

    public Visit getVisit() {
        return this.plugin.getVisitManager().getIsland(this.getOwnerUUID());
    }

    public Ban getBan() {
        return this.plugin.getBanManager().getIsland(this.getOwnerUUID());
    }

    public IslandLevel getLevel() {
        return this.level;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public synchronized void save() {
        FileManager fileManager = this.plugin.getFileManager();
        FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder() + "/island-data", this.ownerUUID.toString() + ".yml"));
        ArrayList<String> tempWhitelist = new ArrayList<String>();
        for (UUID uUID : this.whitelistedPlayers) {
            tempWhitelist.add(FastUUID.toString(uUID));
        }
        config.getFileConfiguration().set("Whitelist", tempWhitelist);
        config.getFileConfiguration().set("Visitor.Status", (Object)this.status.toString());
        try {
            config.getFileConfiguration().save(config.getFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        config = fileManager.getConfig(new File(this.plugin.getDataFolder() + "/setting-data", this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        for (Map.Entry<IslandRole, List<IslandPermission>> entry : this.islandPermissions.entrySet()) {
            for (IslandPermission permission : entry.getValue()) {
                configLoad.set("Settings." + entry.getKey().getFriendlyName().toUpperCase(Locale.US) + "." + permission.getPermission().getName(), (Object)permission.getStatus());
            }
        }
        try {
            configLoad.save(config.getFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!this.plugin.getConfiguration().getBoolean("Island.Coop.Unload")) {
            config = fileManager.getConfig(new File(this.plugin.getDataFolder() + "/coop-data", this.ownerUUID.toString() + ".yml"));
            configLoad = config.getFileConfiguration();
            ArrayList<String> arrayList = new ArrayList<String>(this.coopPlayers.size());
            for (Map.Entry<UUID, IslandCoop> entry : this.coopPlayers.entrySet()) {
                if (entry.getValue() == IslandCoop.TEMP) continue;
                arrayList.add(entry.getKey().toString());
            }
            configLoad.set("CoopPlayers", arrayList);
            try {
                configLoad.save(config.getFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.getLevel().save();
    }

    public boolean isRegionUnlocked(Player player, IslandWorld type) {
        FileManager fileManager = this.plugin.getFileManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        FileConfiguration configLoad = this.plugin.getConfiguration();
        FileManager.Config islandData = fileManager.getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), this.ownerUUID.toString() + ".yml"));
        FileConfiguration configLoadIslandData = islandData.getFileConfiguration();
        double price = configLoad.getDouble("Island.World." + type.getFriendlyName() + ".UnlockPrice");
        boolean unlocked = configLoadIslandData.getBoolean("Unlocked." + type.getFriendlyName());
        if (price == -1.0) {
            configLoadIslandData.set("Unlocked." + type.getFriendlyName(), (Object)true);
            unlocked = true;
        }
        if (!unlocked && player != null) {
            messageManager.sendMessage((CommandSender)player, this.plugin.getLanguage().getString("Island.Unlock." + type.getFriendlyName() + ".Message").replace("%cost%", NumberUtils.formatNumber(price)));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            if (type == IslandWorld.END) {
                player.setVelocity(player.getLocation().getDirection().multiply(-0.5).setY(0.6f));
            } else if (type == IslandWorld.NETHER) {
                player.setVelocity(player.getLocation().getDirection().multiply(-0.5));
            }
        }
        return unlocked;
    }

    public com.craftaro.skyblock.api.island.Island getAPIWrapper() {
        return this.apiWrapper;
    }

    public void addWhitelistedPlayer(UUID uuid) {
        this.whitelistedPlayers.add(uuid);
        this.save();
    }

    public boolean isPlayerWhitelisted(UUID uuid) {
        return this.whitelistedPlayers.contains(uuid);
    }

    public void removeWhitelistedPlayer(UUID uuid) {
        this.whitelistedPlayers.remove(uuid);
        this.save();
    }

    public Set<UUID> getWhitelistedPlayers() {
        return new HashSet<UUID>(this.whitelistedPlayers);
    }

    public void addWhitelistedPlayer(Player player) {
        this.addWhitelistedPlayer(player.getUniqueId());
    }

    public boolean isPlayerWhitelisted(Player player) {
        return this.isPlayerWhitelisted(player.getUniqueId());
    }

    public void removeWhitelistedPlayer(Player player) {
        this.removeWhitelistedPlayer(player.getUniqueId());
    }

    public String toString() {
        return "Island{ownerUUID=" + this.ownerUUID + '}';
    }
}

