/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.wip;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiBans
extends Gui {
    private final PlayerDataManager playerDataManager;
    private final SoundManager soundManager;
    private final Island island;
    private final FileConfiguration languageLoad;

    public GuiBans(SkyBlock plugin, Island island, Gui returnGui) {
        super(returnGui);
        this.playerDataManager = plugin.getPlayerDataManager();
        this.soundManager = plugin.getSoundManager();
        this.island = island;
        this.languageLoad = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        this.setDefaultItem(null);
        this.setTitle(TextUtils.formatText("Bans"));
        this.paint();
    }

    public void paint() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 1, 8, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bans.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bans.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        for (int i = 9; i < 18; ++i) {
            this.setItem(i, XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        }
        ArrayList<UUID> bans = new ArrayList<UUID>(this.island.getBan().getBans());
        if (bans.isEmpty()) {
            this.setItem(31, XMaterial.BARRIER.parseItem());
        } else {
            this.pages = (int)Math.max(1.0, Math.ceil((double)bans.size() / 36.0));
            if (this.page != 1) {
                this.setButton(5, 2, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Last.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    --this.page;
                    this.paint();
                });
            }
            if (this.page != this.pages) {
                this.setButton(5, 6, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Next.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    ++this.page;
                    this.paint();
                });
            }
            for (int i = 9; i < (this.getRows() - 2) * 9 + 18; ++i) {
                ItemStack is;
                String[] targetPlayerTexture;
                String targetPlayerName;
                int current = (this.page - 1) * 36 - 18;
                if (current + i >= bans.size()) {
                    this.setItem(i, null);
                    continue;
                }
                UUID uuid = (UUID)bans.get(current + i);
                if (uuid == null) continue;
                OfflinePlayer targetPlayer = Bukkit.getServer().getOfflinePlayer(uuid);
                if (targetPlayer == null) {
                    com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(uuid);
                    targetPlayerName = offlinePlayer.getName();
                    targetPlayerTexture = offlinePlayer.getTexture();
                } else {
                    targetPlayerName = targetPlayer.getName();
                    targetPlayerTexture = this.playerDataManager.hasPlayerData(targetPlayer.getUniqueId()) ? this.playerDataManager.getPlayerData(targetPlayer.getUniqueId()).getTexture() : new String[]{null, null};
                }
                if (targetPlayerTexture.length >= 1 && targetPlayerTexture[0] != null) {
                    is = SkullItemCreator.byTextureValue(targetPlayerTexture[0]);
                } else {
                    try {
                        is = SkullItemCreator.byUuid(uuid).get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                ItemMeta im = is.getItemMeta();
                if (im != null) {
                    im.setDisplayName(this.languageLoad.getString("Menu.Bans.Item.Ban.Displayname").replace("%player", targetPlayerName == null ? "" : targetPlayerName));
                    im.setLore(this.languageLoad.getStringList("Menu.Bans.Item.Ban.Lore"));
                    is.setItemMeta(im);
                }
                this.setButton(i, is, e -> {
                    String playerName = ChatColor.stripColor((String)is.getItemMeta().getDisplayName());
                    Bukkit.getServer().dispatchCommand((CommandSender)e.player, "island unban " + playerName);
                });
            }
        }
    }
}

