/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.coop;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.gui.coop.GuiCoop;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class GuiCoopChoose
extends Gui {
    private final SkyBlock plugin;
    private final FileConfiguration languageLoad;
    private final Gui returnGui;
    private final String targetPlayer;
    private final Island island;

    public GuiCoopChoose(SkyBlock plugin, Island island, Gui returnGui, String targetPlayer) {
        super(1, returnGui);
        this.plugin = plugin;
        this.returnGui = returnGui;
        this.targetPlayer = targetPlayer;
        this.island = island;
        this.languageLoad = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Word.Normal") + " / " + this.languageLoad.getString("Menu.Coop.Item.Word.Temp")));
        this.paint();
    }

    public void paint() {
        SoundManager soundManager = this.plugin.getSoundManager();
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        this.setActionForRange(0, 4, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            this.guiManager.showGUI(event.player, this.returnGui);
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            this.guiManager.showGUI(event.player, this.returnGui);
        });
        this.setButton(3, GuiUtils.createButtonItem(XMaterial.OBSIDIAN, TextUtils.formatText("&r" + this.languageLoad.getString("Menu.Coop.Item.Word.Normal")), new String[0]), event -> {
            Bukkit.getServer().dispatchCommand((CommandSender)event.player, "island coop " + this.targetPlayer + " " + this.languageLoad.getString("Menu.Coop.Item.Word.Normal"));
            this.guiManager.showGUI(event.player, new GuiCoop(this.plugin, this.island, null));
        });
        this.setButton(5, GuiUtils.createButtonItem(XMaterial.GLASS, TextUtils.formatText("&r" + this.languageLoad.getString("Menu.Coop.Item.Word.Temp")), new String[0]), event -> {
            Bukkit.getServer().dispatchCommand((CommandSender)event.player, "island coop " + this.targetPlayer + " " + this.languageLoad.getString("Menu.Coop.Item.Word.Temp"));
            this.guiManager.showGUI(event.player, new GuiCoop(this.plugin, this.island, null));
        });
    }
}

