/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.coop;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.utils.SkullItemCreator;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.gui.coop.GuiCoopChoose;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandCoop;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiCoop
extends Gui {
    private final SkyBlock plugin;
    private final Island island;
    private final FileConfiguration languageLoad;

    public GuiCoop(SkyBlock plugin, Island island, Gui returnGui) {
        super(6, returnGui);
        this.plugin = plugin;
        this.island = island;
        this.languageLoad = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        this.setDefaultItem(null);
        this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Title")));
        this.paint();
    }

    public void paint() {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        PermissionManager permissionManager = this.plugin.getPermissionManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        Map<UUID, IslandCoop> coopPlayers = this.island.getCoopPlayers();
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 1, 8, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        List addButtonLore = this.languageLoad.getStringList("Menu.Coop.Item.Information.Lore");
        Collections.replaceAll(addButtonLore, "%coops", "" + coopPlayers.size());
        this.setButton(4, GuiUtils.createButtonItem(XMaterial.PAINTING, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Information.Displayname")), TextUtils.formatText(addButtonLore)), event -> {
            if (this.island.hasRole(IslandRole.OPERATOR, event.player.getUniqueId()) && permissionManager.hasPermission(this.island, "CoopPlayers", IslandRole.OPERATOR) || this.island.hasRole(IslandRole.OWNER, event.player.getUniqueId())) {
                AnvilGui gui = new AnvilGui(event.player, (Gui)this);
                gui.setAction(e -> {
                    String playerName = gui.getInputText().trim();
                    this.guiManager.showGUI(event.player, new GuiCoopChoose(this.plugin, this.island, e.gui.getParent(), playerName));
                });
                gui.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Word.Enter")));
                this.guiManager.showGUI(event.player, gui);
            } else {
                messageManager.sendMessage((CommandSender)event.player, this.languageLoad.getString("Command.Island.Coop.Permission.Message"));
                soundManager.playSound((CommandSender)event.player, XSound.ENTITY_VILLAGER_NO);
            }
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        for (int i = 9; i < 18; ++i) {
            this.setItem(i, XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        }
        if (coopPlayers.isEmpty()) {
            ItemStack empty = XMaterial.BARRIER.parseItem();
            ItemMeta emptyMeta = empty.getItemMeta();
            emptyMeta.setDisplayName(TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Nothing.Displayname")));
            empty.setItemMeta(emptyMeta);
            this.setButton(31, empty, event -> soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND));
        } else {
            this.pages = (int)Math.max(1.0, Math.ceil((double)coopPlayers.size() / 36.0));
            if (this.page != 1) {
                this.setButton(5, 2, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Previous.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    --this.page;
                    this.paint();
                });
            }
            if (this.page != this.pages) {
                this.setButton(5, 6, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Next.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    ++this.page;
                    this.paint();
                });
            }
            UUID[] coopUUIDs = new UUID[coopPlayers.size()];
            coopPlayers.keySet().toArray(coopUUIDs);
            for (int i = 18; i < (this.getRows() - 2) * 9 + 18; ++i) {
                int current = (this.page - 1) * 36 - 18;
                if (current + i < coopPlayers.size()) {
                    ItemStack phead;
                    String[] targetPlayerTexture;
                    String targetPlayerName;
                    UUID uuid = coopUUIDs[current + i];
                    IslandCoop type = (IslandCoop)((Object)coopPlayers.values().toArray()[current + i]);
                    if (uuid == null) continue;
                    OfflinePlayer targetPlayer = Bukkit.getServer().getOfflinePlayer(uuid);
                    if (targetPlayer == null) {
                        com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(uuid);
                        targetPlayerName = offlinePlayer.getName();
                        targetPlayerTexture = offlinePlayer.getTexture();
                    } else {
                        targetPlayerName = targetPlayer.getName();
                        targetPlayerTexture = playerDataManager.hasPlayerData(targetPlayer.getUniqueId()) ? playerDataManager.getPlayerData(targetPlayer.getUniqueId()).getTexture() : new String[]{null, null};
                    }
                    if (targetPlayerTexture.length >= 1 && targetPlayerTexture[0] != null) {
                        phead = SkullItemCreator.byTextureValue(targetPlayerTexture[0]);
                    } else {
                        try {
                            phead = SkullItemCreator.byUuid(uuid).get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    ItemMeta pheadmeta = phead.getItemMeta();
                    if (pheadmeta != null) {
                        pheadmeta.setDisplayName(TextUtils.formatText(this.languageLoad.getString("Menu.Coop.Item.Coop.Displayname").replace("%player", targetPlayerName == null ? "" : targetPlayerName).replace("%type", type == IslandCoop.TEMP ? this.languageLoad.getString("Menu.Coop.Item.Word.Temp") : this.languageLoad.getString("Menu.Coop.Item.Word.Normal"))));
                        pheadmeta.setLore(TextUtils.formatText(this.languageLoad.getStringList("Menu.Coop.Item.Coop.Lore")));
                        phead.setItemMeta(pheadmeta);
                    }
                    this.setButton(i, phead, e -> {
                        Bukkit.getServer().dispatchCommand((CommandSender)e.player, "island coop " + targetPlayerName);
                        this.paint();
                    });
                    continue;
                }
                this.setItem(i, null);
            }
        }
    }
}

