/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.biome;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.biome.BiomeManager;
import com.craftaro.skyblock.cooldown.Cooldown;
import com.craftaro.skyblock.cooldown.CooldownManager;
import com.craftaro.skyblock.cooldown.CooldownPlayer;
import com.craftaro.skyblock.cooldown.CooldownType;
import com.craftaro.skyblock.core.compatibility.CompatibleBiome;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.gui.biome.BiomeIcon;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.NumberUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GuiBiome
extends Gui {
    private final SkyBlock plugin;
    private final Island island;
    private final FileConfiguration languageLoad;
    private final Player player;
    private final IslandWorld world;

    public GuiBiome(SkyBlock plugin, Player player, Island island, IslandWorld world, Gui returnGui, boolean admin) {
        super(6, returnGui);
        this.plugin = plugin;
        this.island = island;
        this.world = world;
        this.player = player;
        FileConfiguration config = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "config.yml")).getFileConfiguration();
        this.languageLoad = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        this.setDefaultItem(null);
        this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Title")));
        this.paint();
    }

    public void paint() {
        BiomeIcon icon;
        SoundManager soundManager = this.plugin.getSoundManager();
        BiomeManager biomeManager = this.plugin.getBiomeManager();
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 5, 9, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Item.Exit.Displayname")), new String[0]), event -> {
            soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        List lore = this.languageLoad.getStringList("Menu.Biome.Item.Info.Lore");
        ListIterator<String> i = lore.listIterator();
        while (i.hasNext()) {
            i.set(TextUtils.formatText(((String)i.next()).replace("%biome_type", this.island.getBiomeName())));
        }
        this.setItem(4, GuiUtils.createButtonItem(XMaterial.PAINTING, TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Item.Info.Displayname")), (List<String>)lore));
        for (int i2 = 9; i2 < 18; ++i2) {
            this.setItem(i2, XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        }
        ArrayList<BiomeIcon> biomes = new ArrayList<BiomeIcon>();
        for (CompatibleBiome biome : CompatibleBiome.getCompatibleBiomes()) {
            if (!biome.isCompatible()) continue;
            icon = new BiomeIcon(this.plugin, biome);
            if (icon.biome == null || icon.permission && !this.player.hasPermission("fabledskyblock.biome." + biome.name().toLowerCase())) continue;
            switch (this.world) {
                case NORMAL: {
                    if (!icon.normal) break;
                    biomes.add(icon);
                    break;
                }
                case NETHER: {
                    if (!icon.nether) break;
                    biomes.add(icon);
                    break;
                }
                case END: {
                    if (!icon.end) break;
                    biomes.add(icon);
                }
            }
        }
        if (!biomes.isEmpty()) {
            biomes.sort(Comparator.comparing(m -> m.biome.name()));
            this.pages = (int)Math.max(1.0, Math.ceil((double)biomes.size() / 27.0));
            if (this.page != 1) {
                this.setButton(5, 2, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Item.Last.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    --this.page;
                    this.paint();
                });
            }
            if (this.page != this.pages) {
                this.setButton(5, 6, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Biome.Item.Next.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    ++this.page;
                    this.paint();
                });
            }
            for (int i3 = 18; i3 < (this.getRows() - 2) * 9 + 9; ++i3) {
                int current = (this.page - 1) * 27 - 18;
                if (current + i3 >= biomes.size()) {
                    this.setItem(i3, null);
                    continue;
                }
                icon = (BiomeIcon)biomes.get(current + i3);
                if (icon == null || icon.biome == null || icon.biome.getBiome() == null) continue;
                if (icon.biome.getBiome() == this.island.getBiome()) {
                    icon.enchant();
                }
                this.setButton(i3, icon.displayItem, event -> {
                    if (cooldownManager.hasPlayer(CooldownType.BIOME, (OfflinePlayer)this.player) && !this.player.hasPermission("fabledskyblock.bypass.cooldown")) {
                        CooldownPlayer cooldownPlayer = cooldownManager.getCooldownPlayer(CooldownType.BIOME, (OfflinePlayer)this.player);
                        Cooldown cooldown = cooldownPlayer.getCooldown();
                        if (cooldown.getTime() < 60) {
                            messageManager.sendMessage((CommandSender)this.player, this.languageLoad.getString("Island.Biome.Cooldown.Message").replace("%time", cooldown.getTime() + " " + this.languageLoad.getString("Island.Biome.Cooldown.Word.Second")));
                        } else {
                            long[] durationTime = NumberUtil.getDuration(cooldown.getTime());
                            messageManager.sendMessage((CommandSender)this.player, this.languageLoad.getString("Island.Biome.Cooldown.Message").replace("%time", durationTime[2] + " " + this.languageLoad.getString("Island.Biome.Cooldown.Word.Minute") + " " + durationTime[3] + " " + this.languageLoad.getString("Island.Biome.Cooldown.Word.Second")));
                        }
                        soundManager.playSound((CommandSender)this.player, XSound.ENTITY_VILLAGER_NO);
                        return;
                    }
                    cooldownManager.createPlayer(CooldownType.BIOME, (OfflinePlayer)this.player);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        biomeManager.setBiome(this.island, IslandWorld.NORMAL, icon.biome, () -> {
                            if (this.languageLoad.getBoolean("Command.Island.Biome.Completed.Should-Display-Message")) {
                                messageManager.sendMessage((CommandSender)this.player, this.languageLoad.getString("Command.Island.Biome.Completed.Message"));
                                soundManager.playSound((CommandSender)this.player, XSound.ENTITY_VILLAGER_YES);
                            }
                        });
                        this.island.setBiome(icon.biome.getBiome());
                        this.island.save();
                    });
                    soundManager.playSound(this.island.getLocation(IslandWorld.NORMAL, IslandEnvironment.ISLAND), XSound.ENTITY_GENERIC_SPLASH, 1.0f, 1.0f);
                    if (!islandManager.isPlayerAtIsland(this.island, this.player, IslandWorld.NORMAL)) {
                        soundManager.playSound((CommandSender)this.player, XSound.ENTITY_GENERIC_SPLASH);
                    }
                    this.paint();
                });
            }
        } else {
            this.setItem(31, XMaterial.BARRIER.parseItem());
        }
    }
}

