/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.bank;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.bank.BankManager;
import com.craftaro.skyblock.bank.Transaction;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiBankTransaction
extends Gui {
    private final SoundManager soundManager;
    private final FileConfiguration languageLoad;
    private final Gui returnGui;
    private final int transactions;
    private final List<Transaction> transactionList;
    private final boolean admin;

    public GuiBankTransaction(SkyBlock plugin, Island island, Gui returnGui, boolean admin) {
        super(returnGui);
        BankManager bankManager = plugin.getBankManager();
        this.soundManager = plugin.getSoundManager();
        this.transactionList = bankManager.getTransactions(island.getOwnerUUID());
        this.transactions = this.transactionList.size();
        this.returnGui = returnGui;
        this.admin = admin;
        this.languageLoad = plugin.getLanguage();
        if (this.transactions == 0) {
            this.setRows(2);
        } else if (this.transactions > 36) {
            this.setRows(6);
        } else {
            this.setRows((int)(Math.ceil((double)this.transactions / 9.0) + 1.0));
        }
        this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Title")));
        this.setDefaultItem(null);
        this.paint();
    }

    public void paint() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 1, 8, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            this.guiManager.showGUI(event.player, this.returnGui);
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            this.guiManager.showGUI(event.player, this.returnGui);
        });
        this.setItem(4, GuiUtils.createButtonItem(XMaterial.PAINTING, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Info.Displayname")), TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Info.Lore").replace("%totalTransactions", String.valueOf(this.transactions)))));
        if (this.transactions > 0) {
            this.pages = (int)Math.max(1.0, Math.ceil((double)this.transactions / 36.0));
            if (this.page != 1) {
                this.setButton(5, 2, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Last.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    --this.page;
                    this.paint();
                });
            }
            if (this.page != this.pages) {
                this.setButton(5, 6, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Next.Displayname")), new String[0]), (GuiClickEvent event) -> {
                    ++this.page;
                    this.paint();
                });
            }
            for (int i = 9; i < (this.getRows() - 1) * 9 + 9; ++i) {
                int current = (this.page - 1) * 36 - 9;
                if (current + i >= this.transactions) {
                    this.setItem(i, null);
                    continue;
                }
                Transaction transaction = this.transactionList.get(current + i);
                if (transaction == null) continue;
                ItemStack is = null;
                String name = "";
                SimpleDateFormat formatDate = new SimpleDateFormat(this.languageLoad.getString("Menu.Bank.Item.Transactions.DateTimeFormat", "dd/MM/yyyy HH:mm:ss"));
                switch (transaction.action) {
                    case WITHDRAW: {
                        is = XMaterial.RED_DYE.parseItem();
                        ItemMeta im = is.getItemMeta();
                        if (im == null) break;
                        im.setDisplayName(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Withdraw.Displayname").replace("%dateTime", formatDate.format(transaction.timestamp))));
                        ArrayList<String> lore = new ArrayList<String>();
                        switch (transaction.visibility) {
                            case ADMIN: {
                                name = this.languageLoad.getString("Menu.Bank.Transactions.Admin");
                                if (!this.admin) break;
                                name = name + " " + transaction.player.getName();
                                break;
                            }
                            case USER: {
                                name = transaction.player.getName();
                            }
                        }
                        if (name == null) {
                            name = "null";
                        }
                        lore.add(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Withdraw.Format").replace("%playerName", name).replace("%amount", String.valueOf(transaction.amount))));
                        im.setLore(lore);
                        is.setItemMeta(im);
                        break;
                    }
                    case DEPOSIT: {
                        is = XMaterial.GREEN_DYE.parseItem();
                        ItemMeta im = is.getItemMeta();
                        if (im == null) break;
                        im.setDisplayName(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Deposit.Displayname").replace("%dateTime", formatDate.format(transaction.timestamp))));
                        ArrayList<String> lore = new ArrayList();
                        switch (transaction.visibility) {
                            case ADMIN: {
                                name = this.languageLoad.getString("Menu.Bank.Word.Admin");
                                if (!this.admin) break;
                                name = name + transaction.player.getName();
                                break;
                            }
                            case USER: {
                                name = transaction.player.getName();
                            }
                        }
                        lore.add(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Transactions.Deposit.Format").replace("%playerName", name).replace("%amount", String.valueOf(transaction.amount))));
                        im.setLore(lore);
                        is.setItemMeta(im);
                    }
                }
                this.setItem(i, is);
            }
        } else {
            this.setItem(31, XMaterial.BARRIER.parseItem());
        }
    }
}

