/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.bank;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.bank.BankManager;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.hooks.economies.Economy;
import com.craftaro.skyblock.core.utils.NumberUtils;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class GuiBankSelector
extends Gui {
    private final SkyBlock plugin;
    private final BankManager bankManager;
    private final SoundManager soundManager;
    private final Island island;
    private final FileConfiguration languageLoad;
    private final Type type;
    private final Gui returnGui;
    private final boolean admin;

    public GuiBankSelector(SkyBlock plugin, Island island, Gui returnGui, Type type, boolean admin) {
        super(1, returnGui);
        this.plugin = plugin;
        this.type = type;
        this.bankManager = plugin.getBankManager();
        this.soundManager = plugin.getSoundManager();
        this.island = island;
        this.returnGui = returnGui;
        this.admin = admin;
        this.languageLoad = this.plugin.getLanguage();
        this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Input.Title")));
        this.paint();
    }

    public void paint() {
        String action;
        Economy economy = this.plugin.getEconomyManager().getEconomy();
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        this.setActionForRange(0, 0, 1, 8, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        switch (this.type.ordinal()) {
            case 0: {
                action = "Deposit";
                break;
            }
            case 1: {
                action = "Withdraw";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.type));
            }
        }
        String finalAction = action;
        this.setButton(2, GuiUtils.createButtonItem(XMaterial.GOLD_BLOCK, TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.All.Displayname")), TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.All.Lore").replace("%action%", this.languageLoad.getString("Menu.Bank.Words." + action)))), event -> {
            BankManager.BankResponse response;
            double amount;
            MessageManager messageManager = this.plugin.getMessageManager();
            switch (this.type.ordinal()) {
                case 0: {
                    amount = economy.getBalance((OfflinePlayer)event.player);
                    if (!this.plugin.getConfiguration().getBoolean("Island.Bank.AllowDecimals")) {
                        amount = Math.floor(amount);
                    }
                    response = this.bankManager.deposit(event.player, this.island, amount, this.admin);
                    break;
                }
                case 1: {
                    amount = this.island.getBankBalance();
                    if (!this.plugin.getConfiguration().getBoolean("Island.Bank.AllowDecimals")) {
                        amount = Math.floor(amount);
                    }
                    response = this.bankManager.withdraw(event.player, this.island, amount, this.admin);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.type));
                }
            }
            switch (response) {
                case NOT_ENOUGH_MONEY: {
                    messageManager.sendMessage((CommandSender)event.player, this.languageLoad.getString("Command.Island.Bank.Short2.Message"));
                    this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case DECIMALS_NOT_ALLOWED: {
                    messageManager.sendMessage((CommandSender)event.player, this.languageLoad.getString("Command.Island.Bank.Short6.Message"));
                    this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case NEGATIVE_AMOUNT: {
                    messageManager.sendMessage((CommandSender)event.player, this.languageLoad.getString("Command.Island.Bank.Short5.Message"));
                    this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case SUCCESS: {
                    this.soundManager.playSound((CommandSender)event.player, XSound.ENTITY_EXPERIENCE_ORB_PICKUP);
                    messageManager.sendMessage((CommandSender)event.player, Objects.requireNonNull(this.languageLoad.getString("Command.Island.Bank." + finalAction + ".Message")).replace("%amount%", NumberUtils.formatNumber(amount)));
                }
            }
            this.guiManager.showGUI(event.player, this.returnGui);
        });
        this.setButton(6, GuiUtils.createButtonItem(XMaterial.PAPER, TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.Custom.Displayname")), TextUtils.formatText(this.languageLoad.getString("Menu.Input.Item.Custom.Lore").replace("%action%", this.languageLoad.getString("Menu.Bank.Words." + action)))), event -> {
            AnvilGui gui = new AnvilGui(event.player, this.returnGui);
            gui.setAction(e -> {
                BankManager.BankResponse response;
                double amount;
                MessageManager messageManager = this.plugin.getMessageManager();
                try {
                    amount = gui.getInputText() != null ? Double.parseDouble(gui.getInputText().trim()) : 0.0;
                }
                catch (NumberFormatException e1) {
                    messageManager.sendMessage((CommandSender)e.player, this.languageLoad.getString("Command.Island.Bank.Short4.Message"));
                    this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                switch (this.type.ordinal()) {
                    case 0: {
                        response = this.bankManager.deposit(event.player, this.island, amount, this.admin);
                        break;
                    }
                    case 1: {
                        response = this.bankManager.withdraw(event.player, this.island, amount, this.admin);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.type));
                    }
                }
                switch (response) {
                    case NOT_ENOUGH_MONEY: {
                        messageManager.sendMessage((CommandSender)e.player, this.languageLoad.getString("Command.Island.Bank.Short2.Message"));
                        this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                        break;
                    }
                    case DECIMALS_NOT_ALLOWED: {
                        messageManager.sendMessage((CommandSender)e.player, this.languageLoad.getString("Command.Island.Bank.Short6.Message"));
                        this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                        break;
                    }
                    case NEGATIVE_AMOUNT: {
                        messageManager.sendMessage((CommandSender)e.player, this.languageLoad.getString("Command.Island.Bank.Short5.Message"));
                        this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_ANVIL_LAND);
                        break;
                    }
                    case SUCCESS: {
                        this.soundManager.playSound((CommandSender)event.player, XSound.ENTITY_EXPERIENCE_ORB_PICKUP);
                        messageManager.sendMessage((CommandSender)e.player, Objects.requireNonNull(this.languageLoad.getString("Command.Island.Bank." + finalAction + ".Message")).replace("%amount%", NumberUtils.formatNumber(amount)));
                    }
                }
                e.player.closeInventory();
                this.guiManager.showGUI(event.player, this.returnGui);
            });
            switch (this.type.ordinal()) {
                case 0: {
                    gui.setTitle(this.languageLoad.getString("Menu.Bank.Words.Deposit"));
                    break;
                }
                case 1: {
                    gui.setTitle(this.languageLoad.getString("Menu.Bank.Words.Withdraw"));
                }
            }
            this.guiManager.showGUI(event.player, gui);
        });
    }

    public static enum Type {
        DEPOSIT,
        WITHDRAW;

    }
}

