/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui.bank;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiManager;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.gui.bank.GuiBankSelector;
import com.craftaro.skyblock.gui.bank.GuiBankTransaction;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import javax.annotation.Nonnull;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class GuiBank
extends Gui {
    private final SkyBlock plugin;
    private final SoundManager soundManager;
    private final Island island;
    private final FileConfiguration languageLoad;
    private final boolean admin;

    public GuiBank(SkyBlock plugin, Island island, Gui returnGui, boolean admin) {
        super(2, returnGui);
        this.plugin = plugin;
        this.soundManager = plugin.getSoundManager();
        this.island = island;
        this.admin = admin;
        this.languageLoad = this.plugin.getLanguage();
        if (island != null) {
            this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
            this.setTitle(TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Title")));
            this.paint();
        }
    }

    @Override
    public void onOpen(@Nonnull GuiManager manager, @Nonnull Player player) {
        this.updateItem(13, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Balance.Displayname")), TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Balance.Lore").replace("%balance", String.valueOf(this.island.getBankBalance()))));
        super.onOpen(manager, player);
    }

    public void paint() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setDefaultItem(XMaterial.BLACK_STAINED_GLASS_PANE.parseItem());
        this.setActionForRange(0, 0, 1, 8, null);
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Exit.Displayname")), new String[0]), event -> {
            this.soundManager.playSound((CommandSender)event.player, XSound.BLOCK_CHEST_CLOSE);
            event.player.closeInventory();
        });
        this.setButton(4, GuiUtils.createButtonItem(XMaterial.BOOK, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Log.Displayname")), new String[0]), event -> this.guiManager.showGUI(event.player, new GuiBankTransaction(this.plugin, this.island, this, this.admin)));
        this.setButton(10, GuiUtils.createButtonItem(XMaterial.GREEN_DYE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Deposit.Displayname")), new String[0]), event -> this.guiManager.showGUI(event.player, new GuiBankSelector(this.plugin, this.island, this, GuiBankSelector.Type.DEPOSIT, this.admin)));
        this.setItem(13, GuiUtils.createButtonItem(XMaterial.GOLD_INGOT, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Balance.Displayname")), TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Balance.Lore").replace("%balance", String.valueOf(this.island.getBankBalance())))));
        this.setButton(16, GuiUtils.createButtonItem(XMaterial.RED_DYE, TextUtils.formatText(this.languageLoad.getString("Menu.Bank.Item.Withdraw.Displayname")), new String[0]), event -> this.guiManager.showGUI(event.player, new GuiBankSelector(this.plugin, this.island, this, GuiBankSelector.Type.WITHDRAW, this.admin)));
    }
}

