/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.gui;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.utils.TextUtils;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandMessage;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class GuiSignatureEditor
extends Gui {
    private final SkyBlock plugin;
    private final FileConfiguration configLoad;
    private final Gui returnGui;
    private final Island island;
    private final FileManager.Config mainConfig;
    private final MessageManager messageManager;
    private final IslandManager islandManager;

    public GuiSignatureEditor(SkyBlock plugin, Gui returnGui, Island island) {
        super(1);
        this.plugin = plugin;
        this.returnGui = returnGui;
        this.island = island;
        this.configLoad = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        this.mainConfig = plugin.getFileManager().getConfig(new File(plugin.getDataFolder(), "config.yml"));
        this.messageManager = plugin.getMessageManager();
        this.islandManager = plugin.getIslandManager();
        this.setDefaultItem(null);
        this.setTitle(TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Title")));
        this.paint();
    }

    public void paint() {
        List<String> signatureMessage = this.island.getMessage(IslandMessage.SIGNATURE);
        this.setButton(2, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Return.Displayname")), new String[0]), event -> this.guiManager.showGUI(event.player, this.returnGui));
        this.setButton(6, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Return.Displayname")), new String[0]), event -> this.guiManager.showGUI(event.player, this.returnGui));
        this.setButton(3, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Line.Add.Displayname")), TextUtils.formatText(this.configLoad.getStringList(signatureMessage.size() == this.mainConfig.getFileConfiguration().getInt("Island.Visitor.Signature.Lines") ? "Menu.Settings.Visitor.Panel.Signature.Item.Line.Add.Limit.Lore" : "Menu.Settings.Visitor.Panel.Signature.Item.Line.Add.More.Lore"))), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                if (!this.hasPermission(e.player)) {
                    return;
                }
                if (this.island.getMessage(IslandMessage.SIGNATURE).size() > this.mainConfig.getFileConfiguration().getInt("Island.Visitor.Signature.Lines") || gui.getInputText().length() > this.mainConfig.getFileConfiguration().getInt("Island.Visitor.Signature.Length")) {
                    this.plugin.getSoundManager().playSound((CommandSender)e.player, XSound.BLOCK_ANVIL_LAND);
                } else {
                    signatureMessage.add(gui.getInputText().trim());
                    this.island.setMessage(IslandMessage.SIGNATURE, e.player.getName(), signatureMessage);
                    this.plugin.getSoundManager().playSound((CommandSender)e.player, XSound.BLOCK_NOTE_BLOCK_PLING);
                }
                e.player.closeInventory();
                this.paint();
            });
            gui.setTitle(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Line.Add.Word.Enter"));
            this.guiManager.showGUI(event.player, gui);
        });
        ArrayList<String> itemLore = new ArrayList<String>();
        itemLore.add(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Message.Word.Empty"));
        this.setItem(4, GuiUtils.createButtonItem(XMaterial.OAK_SIGN, TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Message.Displayname")), TextUtils.formatText(signatureMessage.isEmpty() ? itemLore : signatureMessage)));
        this.setButton(5, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText(this.configLoad.getString("Menu.Settings.Visitor.Panel.Signature.Item.Line.Remove.Displayname")), TextUtils.formatText(this.configLoad.getStringList(signatureMessage.isEmpty() ? "Menu.Settings.Visitor.Panel.Signature.Item.Line.Remove.None.Lore" : "Menu.Settings.Visitor.Panel.Signature.Item.Line.Remove.Lines.Lore"))), event -> {
            signatureMessage.remove(signatureMessage.size() - 1);
            this.island.setMessage(IslandMessage.SIGNATURE, event.player.getName(), signatureMessage);
            this.paint();
        });
    }

    private boolean hasPermission(Player player) {
        Island island1 = this.islandManager.getIsland((OfflinePlayer)player);
        if (island1 == null) {
            this.messageManager.sendMessage((CommandSender)player, this.configLoad.getString("Command.Island.Settings.Owner.Message"));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            player.closeInventory();
            return false;
        }
        if (!island1.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && !island1.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            this.messageManager.sendMessage((CommandSender)player, this.configLoad.getString("Command.Island.Role.Message"));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            player.closeInventory();
            return false;
        }
        if (!this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "config.yml")).getFileConfiguration().getBoolean("Island.Visitor.Signature.Enable")) {
            this.messageManager.sendMessage((CommandSender)player, this.configLoad.getString("Island.Settings.Visitor.Signature.Disabled.Message"));
            this.plugin.getSoundManager().playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            return false;
        }
        return true;
    }
}

