/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.third_party.com.georgev22.api.libraryloader;

import com.craftaro.skyblock.core.third_party.com.georgev22.api.libraryloader.ClassLoaderAccess;
import com.craftaro.skyblock.core.third_party.com.georgev22.api.libraryloader.annotations.MavenLibrary;
import com.craftaro.skyblock.core.third_party.com.georgev22.api.libraryloader.exceptions.InvalidDependencyException;
import com.craftaro.skyblock.core.third_party.com.georgev22.api.libraryloader.exceptions.UnknownDependencyException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public final class LibraryLoader {
    private static ClassLoaderAccess classLoaderAccess;
    private final Logger logger;
    private final File dataFolder;
    private final List<Dependency> dependencyList = new ArrayList<Dependency>();

    public <T> LibraryLoader(@NotNull URLClassLoader classLoader, @NotNull File dataFolder, @NotNull Logger logger) {
        classLoaderAccess = new ClassLoaderAccess(classLoader);
        this.logger = logger;
        this.dataFolder = dataFolder;
    }

    public <T> LibraryLoader(@NotNull ClassLoader classLoader, @NotNull File dataFolder, @NotNull Logger logger) {
        classLoaderAccess = new ClassLoaderAccess(classLoader);
        this.logger = logger;
        this.dataFolder = dataFolder;
    }

    public <T> LibraryLoader(@NotNull URLClassLoader classLoader, @NotNull File dataFolder) {
        classLoaderAccess = new ClassLoaderAccess(classLoader);
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.dataFolder = dataFolder;
    }

    public <T> LibraryLoader(@NotNull ClassLoader classLoader, @NotNull File dataFolder) {
        classLoaderAccess = new ClassLoaderAccess(classLoader);
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.dataFolder = dataFolder;
    }

    public <T> LibraryLoader(@NotNull File dataFolder) {
        classLoaderAccess = new ClassLoaderAccess(this.getClass().getClassLoader());
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.dataFolder = dataFolder;
    }

    public void loadAll(@NotNull Object object, boolean pathCheck) throws InvalidDependencyException, UnknownDependencyException {
        this.loadAll(object.getClass(), pathCheck);
    }

    public <T> void loadAll(@NotNull Class<T> clazz, boolean pathCheck) throws InvalidDependencyException, UnknownDependencyException {
        MavenLibrary[] libs;
        for (MavenLibrary lib : libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class)) {
            if (!(lib.groupId().equalsIgnoreCase("") && lib.artifactId().equalsIgnoreCase("") && lib.version().equalsIgnoreCase(""))) {
                this.load(lib.groupId(), lib.artifactId(), lib.version(), lib.repo().value(), pathCheck);
                continue;
            }
            String[] dependency = lib.value().split(":", 4);
            this.load(dependency[0], dependency[1], dependency[2], dependency[3], pathCheck);
        }
    }

    public void load(String groupId, String artifactId, String version, String repoUrl, boolean pathCheck) throws InvalidDependencyException, UnknownDependencyException {
        this.load(new Dependency(groupId, artifactId, version, repoUrl), pathCheck);
    }

    public void load(@NotNull Dependency d, boolean pathCheck) throws InvalidDependencyException, UnknownDependencyException {
        File saveLocation;
        if (this.dependencyList.contains(d)) {
            this.logger.warning(String.format("Dependency %s:%s:%s is already loaded!", d.groupId, d.artifactId, d.version));
            return;
        }
        this.logger.info(String.format("Loading dependency %s:%s:%s from %s", d.groupId, d.artifactId, d.version, d.repoUrl));
        String name = d.artifactId + "-" + d.version;
        File saveLocationDir = new File(this.getLibFolder(), d.groupId.replace(".", File.separator) + File.separator + d.artifactId.replace(".", File.separator) + File.separator + d.version);
        if (!saveLocationDir.exists()) {
            this.logger.info(String.format("Creating directory for dependency %s:%s:%s from %s", d.groupId, d.artifactId, d.version, d.repoUrl));
            if (saveLocationDir.mkdirs()) {
                this.logger.info(String.format("The directory for dependency %s:%s:%s was successfully created!!", d.groupId, d.artifactId, d.version));
            }
        }
        if (!(saveLocation = new File(saveLocationDir, name + ".jar")).exists()) {
            try {
                this.logger.info("Dependency '" + name + "' does not exist in the libraries folder. Attempting to download...");
                URL url = d.url();
                try (InputStream is = url.openStream();){
                    Files.copy(is, saveLocation.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new UnknownDependencyException(e, "Unable to download '" + d + "' dependency.");
            }
            this.logger.info("Dependency '" + name + "' successfully downloaded.");
        }
        if (!saveLocation.exists()) {
            throw new UnknownDependencyException("Unable to download '" + d + "' dependency.");
        }
        try {
            if (pathCheck & (classLoaderAccess.contains(saveLocation.toURI().toURL()) | classLoaderAccess.contains(d))) {
                throw new InvalidDependencyException("Dependency " + d + " is already in the class path.");
            }
            classLoaderAccess.add(saveLocation.toURI().toURL());
        }
        catch (Exception e) {
            throw new InvalidDependencyException("Unable to load '" + saveLocation + "' dependency.", e);
        }
        this.logger.info("Loaded dependency '" + name + "' successfully.");
        this.dependencyList.add(d);
    }

    public void unloadAll() throws InvalidDependencyException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(this.dependencyList);
        for (Dependency d : dependencies) {
            this.unload(d);
        }
    }

    public void unload(Dependency d) throws InvalidDependencyException {
        if (!this.dependencyList.contains(d)) {
            this.logger.warning(String.format("Dependency %s:%s:%s is not loaded!", d.groupId, d.artifactId, d.version));
            return;
        }
        this.logger.info(String.format("Unloading dependency %s:%s:%s", d.groupId, d.artifactId, d.version));
        String name = d.artifactId + "-" + d.version;
        File saveLocationDir = new File(this.getLibFolder(), d.groupId.replace(".", File.separator) + File.separator + d.artifactId.replace(".", File.separator) + File.separator + d.version);
        if (!saveLocationDir.exists()) {
            throw new InvalidDependencyException(String.format("The directory for dependency %s:%s:%s does not exists!!", d.groupId, d.artifactId, d.version));
        }
        File saveLocation = new File(saveLocationDir, name + ".jar");
        if (!saveLocation.exists()) {
            throw new InvalidDependencyException("Unable to unload '" + d + "' dependency.");
        }
        try {
            classLoaderAccess.remove(saveLocation.toURI().toURL());
        }
        catch (Exception e) {
            throw new InvalidDependencyException("Unable to unload dependency " + d, e);
        }
        this.logger.info(String.format("Unloaded dependency %s:%s:%s successfully", d.groupId, d.artifactId, d.version));
        this.dependencyList.remove(d);
    }

    @NotNull
    public File getLibFolder() {
        File libs = new File(this.dataFolder, "libraries");
        if (libs.mkdirs()) {
            this.logger.info("libraries folder created!");
        }
        return libs;
    }

    @Contract(pure=true)
    @NotNull
    public @UnmodifiableView List<Dependency> getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "LibraryLoader{dataFolder=" + this.dataFolder + ", dependencyList=" + this.dependencyList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryLoader that = (LibraryLoader)o;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.dataFolder, that.dataFolder) && Objects.equals(this.getDependencyList(), that.getDependencyList());
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.dataFolder, this.getDependencyList());
    }

    @Contract(value="_, null -> fail; _, !null -> param2", pure=true)
    @NotNull
    private static <T> T notNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    @NotNull
    public static class Dependency {
        public final String groupId;
        public final String artifactId;
        public final String version;
        public final String repoUrl;

        public Dependency(String groupId, String artifactId, String version, String repoUrl) {
            this.groupId = (String)LibraryLoader.notNull("groupId", groupId);
            this.artifactId = (String)LibraryLoader.notNull("artifactId", artifactId);
            this.version = (String)LibraryLoader.notNull("version", version);
            this.repoUrl = (String)LibraryLoader.notNull("repoUrl", repoUrl);
        }

        @Contract(value=" -> new")
        @NotNull
        public URL url() throws MalformedURLException {
            String repo = this.repoUrl;
            if (!repo.endsWith("/")) {
                repo = repo + "/";
            }
            repo = repo + "%s/%s/%s/%s-%s.jar";
            String url = String.format(repo, this.groupId.replace(".", "/"), this.artifactId, this.version, this.artifactId, this.version);
            return new URL(url);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version) && this.repoUrl.equals(that.repoUrl);
        }

        @NotNull
        public String toString() {
            return "LibraryLoader.Dependency(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", repoUrl=" + this.repoUrl + ")";
        }

        @Contract(value="_ -> new")
        @NotNull
        public static Dependency fromString(@NotNull String string) {
            String[] arguments = string.split(Pattern.quote(", "));
            String groupId = arguments[0].substring(arguments[0].indexOf("=") + 1);
            String artifactId = arguments[1].substring(arguments[1].indexOf("=") + 1);
            String version = arguments[2].substring(arguments[2].indexOf("=") + 1);
            String repoUrl = arguments[3].substring(arguments[3].indexOf("=") + 1, arguments[3].lastIndexOf(")"));
            return new Dependency(groupId, artifactId, version, repoUrl);
        }
    }
}

