/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.nms.v1_20_R2.world;

import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.CompatibleParticleHandler;
import com.craftaro.skyblock.core.nms.world.SSpawner;
import com.craftaro.skyblock.core.nms.world.SpawnedEntity;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SSpawnerImpl
implements SSpawner {
    private final Location spawnerLocation;

    public SSpawnerImpl(Location location) {
        this.spawnerLocation = location;
    }

    @Override
    public LivingEntity spawnEntity(EntityType type, Location spawnerLocation) {
        return this.spawnEntity(type, "EXPLOSION_NORMAL", null, null);
    }

    @Override
    public LivingEntity spawnEntity(EntityType type, String particleType, SpawnedEntity spawned, Set<XMaterial> canSpawnOn) {
        MobSpawnerData data = new MobSpawnerData();
        NBTTagCompound compound = data.a();
        String name = type.name().toLowerCase().replace("snowman", "snow_golem").replace("mushroom_cow", "mooshroom");
        compound.a("id", "minecraft:" + name);
        int spawnRange = 4;
        for (int i = 0; i < 50; ++i) {
            Location spot;
            EntityInsentient entityInsentient;
            assert (this.spawnerLocation.getWorld() != null);
            WorldServer world = ((CraftWorld)this.spawnerLocation.getWorld()).getHandle();
            RandomSource random = world.D_();
            double x = this.spawnerLocation.getX() + (random.j() - random.j()) * (double)spawnRange + 0.5;
            double y = this.spawnerLocation.getY() + (double)random.a(3) - 1.0;
            double z = this.spawnerLocation.getZ() + (random.j() - random.j()) * (double)spawnRange + 0.5;
            Optional optionalEntity = EntityTypes.a((NBTTagCompound)compound, (World)world);
            if (optionalEntity.isEmpty()) continue;
            Entity entity = (Entity)optionalEntity.get();
            entity.e(x, y, z);
            BlockPosition position = entity.dl();
            DifficultyDamageScaler damageScaler = world.d_(position);
            if (!(entity instanceof EntityInsentient) || !this.canSpawn(world, entityInsentient = (EntityInsentient)entity, spot = new Location(this.spawnerLocation.getWorld(), x, y, z), canSpawnOn)) continue;
            entityInsentient.a((WorldAccess)world, damageScaler, EnumMobSpawn.c, null, null);
            LivingEntity craftEntity = (LivingEntity)entity.getBukkitEntity();
            if (spawned != null && !spawned.onSpawn(craftEntity)) {
                return null;
            }
            if (particleType != null) {
                float xx = (float)(0.0 + Math.random() * 1.0);
                float yy = (float)(0.0 + Math.random() * 2.0);
                float zz = (float)(0.0 + Math.random() * 1.0);
                CompatibleParticleHandler.spawnParticles(CompatibleParticleHandler.ParticleType.getParticle(particleType), spot, 5, xx, yy, zz, 0.0);
            }
            world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER);
            spot.setYaw(random.i() * 360.0f);
            craftEntity.teleport(spot);
            return craftEntity;
        }
        return null;
    }

    private boolean canSpawn(WorldServer world, EntityInsentient entityInsentient, Location location, Set<XMaterial> canSpawnOn) {
        if (!world.a((Entity)entityInsentient, entityInsentient.cG())) {
            return false;
        }
        Optional<XMaterial> spawnedIn = CompatibleMaterial.getMaterial(location.getBlock().getType());
        Optional<XMaterial> spawnedOn = CompatibleMaterial.getMaterial(location.getBlock().getRelative(BlockFace.DOWN).getType());
        if (spawnedIn.isEmpty() || spawnedOn.isEmpty()) {
            return false;
        }
        if (!(CompatibleMaterial.isAir(spawnedIn.get()) || spawnedIn.get() == XMaterial.WATER || spawnedIn.get().name().contains("PRESSURE") || spawnedIn.get().name().contains("SLAB"))) {
            return false;
        }
        for (XMaterial material : canSpawnOn) {
            if (material == null || spawnedOn.get() != material && !CompatibleMaterial.isAir(material)) continue;
            return true;
        }
        return false;
    }
}

