/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.nms.v1_19_R2.world.spawner;

import com.craftaro.skyblock.core.nms.world.BBaseSpawner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R2.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BBaseSpawnerImpl
implements BBaseSpawner {
    private final CreatureSpawner bukkitSpawner;
    private final MobSpawnerAbstract spawner;
    private final Method setNextSpawnDataMethod;
    private final Method getOrCreateNextSpawnDataMethod;

    public BBaseSpawnerImpl(CreatureSpawner bukkitSpawner, MobSpawnerAbstract spawner) throws NoSuchMethodException {
        this.bukkitSpawner = bukkitSpawner;
        this.spawner = spawner;
        this.setNextSpawnDataMethod = this.spawner.getClass().getDeclaredMethod("a", World.class, BlockPosition.class, MobSpawnerData.class);
        if (!this.setNextSpawnDataMethod.canAccess(this.spawner)) {
            this.setNextSpawnDataMethod.setAccessible(true);
        }
        this.getOrCreateNextSpawnDataMethod = this.spawner.getClass().getSuperclass().getDeclaredMethod("b", World.class, RandomSource.class, BlockPosition.class);
        if (!this.getOrCreateNextSpawnDataMethod.canAccess(this.spawner)) {
            this.getOrCreateNextSpawnDataMethod.setAccessible(true);
        }
    }

    @Override
    public boolean isNearPlayer() {
        BlockPosition bPos = this.getBlockPosition();
        return this.getWorld().a((double)bPos.u() + 0.5, (double)bPos.v() + 0.5, (double)bPos.w() + 0.5, (double)this.spawner.n);
    }

    @Override
    public void tick() throws InvocationTargetException, IllegalAccessException {
        block18: {
            BlockPosition bPos;
            WorldServer world;
            block17: {
                world = this.getWorld();
                bPos = this.getBlockPosition();
                if (this.spawner.d == -1) {
                    this.delay(world, bPos);
                }
                if (this.spawner.d <= 0) break block17;
                --this.spawner.d;
                break block18;
            }
            boolean flag = false;
            RandomSource randomsource = world.s_();
            MobSpawnerData mobspawnerdata = (MobSpawnerData)this.getOrCreateNextSpawnDataMethod.invoke((Object)this.spawner, world, randomsource, bPos);
            int i = 0;
            while (true) {
                block19: {
                    Entity entity;
                    BlockPosition blockposition1;
                    block20: {
                        MobSpawnerData.a mobspawnerdata_a;
                        double d2;
                        if (i >= this.spawner.k) {
                            if (!flag) break;
                            this.delay(world, bPos);
                            break;
                        }
                        NBTTagCompound nbttagcompound = mobspawnerdata.a();
                        Optional optional = EntityTypes.a((NBTTagCompound)nbttagcompound);
                        if (optional.isEmpty()) {
                            this.delay(world, bPos);
                            return;
                        }
                        NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
                        int j = nbttaglist.size();
                        double d0 = j >= 1 ? nbttaglist.h(0) : (double)bPos.u() + (randomsource.j() - randomsource.j()) * (double)this.spawner.o + 0.5;
                        double d1 = j >= 2 ? nbttaglist.h(1) : (double)(bPos.v() + randomsource.a(3) - 1);
                        double d = d2 = j >= 3 ? nbttaglist.h(2) : (double)bPos.w() + (randomsource.j() - randomsource.j()) * (double)this.spawner.o + 0.5;
                        if (!world.b(((EntityTypes)optional.get()).a(d0, d1, d2))) break block19;
                        blockposition1 = new BlockPosition(d0, d1, d2);
                        if (!mobspawnerdata.b().isPresent() ? !EntityPositionTypes.a((EntityTypes)((EntityTypes)optional.get()), (WorldAccess)world, (EnumMobSpawn)EnumMobSpawn.c, (BlockPosition)blockposition1, (RandomSource)world.s_()) : !((EntityTypes)optional.get()).f().d() && world.ah() == EnumDifficulty.a || !(mobspawnerdata_a = (MobSpawnerData.a)mobspawnerdata.b().get()).a().a((Comparable)Integer.valueOf(world.a(EnumSkyBlock.b, blockposition1))) || !mobspawnerdata_a.b().a((Comparable)Integer.valueOf(world.a(EnumSkyBlock.a, blockposition1)))) break block19;
                        entity = EntityTypes.a((NBTTagCompound)nbttagcompound, (World)world, entity1 -> {
                            entity1.b(d0, d1, d2, entity1.dv(), entity1.dx());
                            return entity1;
                        });
                        if (entity == null) {
                            this.delay(world, bPos);
                            return;
                        }
                        int k = world.a(entity.getClass(), new AxisAlignedBB((double)bPos.u(), (double)bPos.v(), (double)bPos.w(), (double)(bPos.u() + 1), (double)(bPos.v() + 1), (double)(bPos.w() + 1)).g((double)this.spawner.o)).size();
                        if (k >= this.spawner.m) {
                            this.delay(world, bPos);
                            return;
                        }
                        entity.b(entity.dk(), entity.dm(), entity.dq(), randomsource.i() * 360.0f, 0.0f);
                        if (!(entity instanceof EntityInsentient)) break block20;
                        EntityInsentient entityinsentient = (EntityInsentient)entity;
                        if (mobspawnerdata.b().isEmpty() && !entityinsentient.a((GeneratorAccess)world, EnumMobSpawn.c) || !entityinsentient.a((IWorldReader)world)) break block19;
                        if (mobspawnerdata.a().f() == 1 && mobspawnerdata.a().b("id", 8)) {
                            ((EntityInsentient)entity).a((WorldAccess)world, world.d_(entity.df()), EnumMobSpawn.c, null, null);
                        }
                        if (entityinsentient.s.spigotConfig.nerfSpawnerMobs) {
                            entityinsentient.aware = false;
                        }
                    }
                    if (CraftEventFactory.callSpawnerSpawnEvent((Entity)entity, (BlockPosition)bPos).isCancelled()) {
                        Entity vehicle = entity.cV();
                        if (vehicle != null) {
                            vehicle.ak();
                        }
                        for (Entity passenger : entity.cR()) {
                            passenger.ak();
                        }
                    } else {
                        if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                            this.delay(world, bPos);
                            return;
                        }
                        world.c(2004, bPos, 0);
                        world.a(entity, GameEvent.s, blockposition1);
                        if (entity instanceof EntityInsentient) {
                            ((EntityInsentient)entity).M();
                        }
                        flag = true;
                    }
                }
                ++i;
            }
        }
    }

    private void delay(WorldServer world, BlockPosition bPos) throws InvocationTargetException, IllegalAccessException {
        RandomSource randomsource = world.w;
        this.spawner.d = this.spawner.j <= this.spawner.i ? this.spawner.i : this.spawner.i + randomsource.a(this.spawner.j - this.spawner.i);
        Optional weightedEntry = this.spawner.e.b(randomsource);
        if (weightedEntry.isPresent()) {
            this.setNextSpawnDataMethod.invoke((Object)this.spawner, world, bPos, ((WeightedEntry.b)weightedEntry.get()).b());
        }
        this.spawner.a((World)world, bPos, 1);
    }

    private WorldServer getWorld() {
        return ((CraftWorld)this.bukkitSpawner.getWorld()).getHandle();
    }

    private BlockPosition getBlockPosition() {
        return ((CraftCreatureSpawner)this.bukkitSpawner).getPosition();
    }
}

