/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.nms.v1_14_R1.world;

import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.CompatibleParticleHandler;
import com.craftaro.skyblock.core.nms.world.SSpawner;
import com.craftaro.skyblock.core.nms.world.SpawnedEntity;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.DifficultyDamageScaler;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumMobSpawn;
import net.minecraft.server.v1_14_R1.GeneratorAccess;
import net.minecraft.server.v1_14_R1.MobSpawnerData;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SSpawnerImpl
implements SSpawner {
    private final Location spawnerLocation;

    public SSpawnerImpl(Location location) {
        this.spawnerLocation = location;
    }

    @Override
    public LivingEntity spawnEntity(EntityType type, Location spawnerLocation) {
        return this.spawnEntity(type, "EXPLOSION_NORMAL", null, null);
    }

    @Override
    public LivingEntity spawnEntity(EntityType type, String particleType, SpawnedEntity spawned, Set<XMaterial> canSpawnOn) {
        MobSpawnerData data = new MobSpawnerData();
        NBTTagCompound compound = data.getEntity();
        String name = type.name().toLowerCase().replace("snowman", "snow_golem").replace("mushroom_cow", "mooshroom");
        compound.setString("id", "minecraft:" + name);
        int spawnRange = 4;
        for (int i = 0; i < 50; ++i) {
            Location spot;
            EntityInsentient entityInsentient;
            WorldServer world = ((CraftWorld)this.spawnerLocation.getWorld()).getHandle();
            Random random = world.getRandom();
            double x = this.spawnerLocation.getX() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            double y = this.spawnerLocation.getY() + (double)random.nextInt(3) - 1.0;
            double z = this.spawnerLocation.getZ() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            Optional optionalEntity = EntityTypes.a((NBTTagCompound)compound, (World)world);
            if (!optionalEntity.isPresent()) continue;
            Entity entity = (Entity)optionalEntity.get();
            entity.setPosition(x, y, z);
            BlockPosition position = entity.getChunkCoordinates();
            DifficultyDamageScaler damageScaler = world.getDamageScaler(position);
            if (!(entity instanceof EntityInsentient) || !this.canSpawn(world, entityInsentient = (EntityInsentient)entity, spot = new Location(this.spawnerLocation.getWorld(), x, y, z), canSpawnOn)) continue;
            entityInsentient.prepare((GeneratorAccess)world, damageScaler, EnumMobSpawn.SPAWNER, null, null);
            LivingEntity craftEntity = (LivingEntity)entity.getBukkitEntity();
            if (spawned != null && !spawned.onSpawn(craftEntity)) {
                return null;
            }
            if (particleType != null) {
                float xx = (float)(0.0 + Math.random() * 1.0);
                float yy = (float)(0.0 + Math.random() * 2.0);
                float zz = (float)(0.0 + Math.random() * 1.0);
                CompatibleParticleHandler.spawnParticles(CompatibleParticleHandler.ParticleType.getParticle(particleType), spot, 5, xx, yy, zz, 0.0);
            }
            world.addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER);
            spot.setYaw(random.nextFloat() * 360.0f);
            craftEntity.teleport(spot);
            return craftEntity;
        }
        return null;
    }

    private boolean canSpawn(WorldServer world, EntityInsentient entityInsentient, Location location, Set<XMaterial> canSpawnOn) {
        if (!world.getCubes((Entity)entityInsentient, entityInsentient.getBoundingBox())) {
            return false;
        }
        Optional<XMaterial> spawnedIn = CompatibleMaterial.getMaterial(location.getBlock().getType());
        Optional<XMaterial> spawnedOn = CompatibleMaterial.getMaterial(location.getBlock().getRelative(BlockFace.DOWN).getType());
        if (!spawnedIn.isPresent() || !spawnedOn.isPresent()) {
            return false;
        }
        if (!(CompatibleMaterial.isAir(spawnedIn.get()) || spawnedIn.get() == XMaterial.WATER || spawnedIn.get().name().contains("PRESSURE") || spawnedIn.get().name().contains("SLAB"))) {
            return false;
        }
        for (XMaterial material : canSpawnOn) {
            if (material == null || spawnedOn.get() != material && !CompatibleMaterial.isAir(material)) continue;
            return true;
        }
        return false;
    }
}

