/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.http;

import com.craftaro.skyblock.core.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;

public class HttpResponseImpl
implements HttpResponse,
AutoCloseable {
    protected final HttpURLConnection connection;
    protected byte[] body;

    HttpResponseImpl(HttpURLConnection connection) throws IOException {
        this.connection = connection;
        this.connection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        int statusCode = this.connection.getResponseCode();
        if (statusCode == -1) {
            throw new IOException("HTTP Status Code is -1");
        }
        return statusCode;
    }

    @Override
    public byte[] getBody() throws IOException {
        if (this.body == null) {
            try (InputStream err = this.connection.getErrorStream();){
                if (err != null) {
                    byte[] byArray = this.body = this.toByteArray(err);
                    return byArray;
                }
            }
            try (InputStream in = this.connection.getInputStream();){
                this.body = this.toByteArray(in);
            }
        }
        return this.body;
    }

    @Override
    public String getBodyAsString() throws IOException {
        return new String(this.getBody(), StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws Exception {
        this.connection.disconnect();
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = in.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }
}

