/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.hooks.hologram.adapter;

import com.craftaro.skyblock.core.hooks.hologram.HologramHook;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecentHologramsHook
extends HologramHook {
    private static final String DECENT_HOLOGRAMS = "DecentHolograms";
    private final ArrayList<String> ourHologramIds = new ArrayList(0);
    private String hologramNamePrefix;

    @Override
    public String getName() {
        return DECENT_HOLOGRAMS;
    }

    @Override
    @NotNull
    public String[] getPluginDependencies() {
        return new String[]{DECENT_HOLOGRAMS};
    }

    @Override
    public void activate(Plugin plugin) {
        this.hologramNamePrefix = plugin.getClass().getName().replace('.', '_') + "-";
    }

    @Override
    public void deactivate() {
        this.removeAll();
        this.hologramNamePrefix = null;
    }

    @Override
    public boolean exists(@NotNull String id) {
        return DHAPI.getHologram((String)this.getHologramName(id)) != null;
    }

    @Override
    public void create(@NotNull String id, @NotNull Location location, @NotNull List<String> lines) {
        if (this.exists(id)) {
            throw new IllegalStateException("Cannot create hologram that already exists: " + this.getHologramName(id));
        }
        DHAPI.createHologram((String)this.getHologramName(id), (Location)this.getNormalizedLocation(location), lines);
        this.ourHologramIds.add(id);
    }

    @Override
    public void update(@NotNull String id, @NotNull List<String> lines) {
        Hologram hologram = DHAPI.getHologram((String)this.getHologramName(id));
        if (hologram == null) {
            throw new IllegalStateException("Cannot update hologram that does not exist: " + this.getHologramName(id));
        }
        DHAPI.setHologramLines((Hologram)hologram, lines);
    }

    @Override
    public void updateBulk(@NotNull Map<String, List<String>> hologramData) {
        for (Map.Entry<String, List<String>> entry : hologramData.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(@Nullable String id) {
        DHAPI.removeHologram((String)this.getHologramName(id));
        this.ourHologramIds.remove(id);
    }

    @Override
    public void removeAll() {
        for (String id : this.ourHologramIds) {
            DHAPI.removeHologram((String)this.getHologramName(id));
        }
        this.ourHologramIds.clear();
        this.ourHologramIds.trimToSize();
    }

    private String getHologramName(String id) {
        if (this.hologramNamePrefix == null) {
            throw new IllegalStateException("Hook has not been activated yet");
        }
        return this.hologramNamePrefix + id;
    }
}

