/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.hooks.hologram.adapter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Holograms.HologramManager;
import com.craftaro.skyblock.core.hooks.hologram.HologramHook;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Container.CMILocation;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CmiHologramHook
extends HologramHook {
    private static final String CMI_PLUGIN_NAME = "CMI";
    private final ArrayList<String> ourHologramIds = new ArrayList(0);
    private String hologramNamePrefix;
    private HologramManager cmiHologramManager;

    @Override
    public String getName() {
        return CMI_PLUGIN_NAME;
    }

    @Override
    @NotNull
    public String[] getPluginDependencies() {
        return new String[]{CMI_PLUGIN_NAME};
    }

    @Override
    public void activate(Plugin plugin) {
        this.hologramNamePrefix = plugin.getClass().getName() + "-";
        this.cmiHologramManager = ((CMI)JavaPlugin.getPlugin(CMI.class)).getHologramManager();
    }

    @Override
    public void deactivate() {
        this.removeAll();
        this.hologramNamePrefix = null;
        this.cmiHologramManager = null;
    }

    @Override
    public boolean exists(@NotNull String id) {
        return this.cmiHologramManager.getByName(this.getHologramName(id)) != null;
    }

    @Override
    public void create(@NotNull String id, @NotNull Location location, @NotNull List<String> lines) {
        if (this.exists(id)) {
            throw new IllegalStateException("Cannot create hologram that already exists: " + this.getHologramName(id));
        }
        CMIHologram hologram = new CMIHologram(this.getHologramName(id), new CMILocation(this.getNormalizedLocation(location)));
        hologram.setLines(lines);
        this.cmiHologramManager.addHologram(hologram);
        hologram.update();
        this.ourHologramIds.add(id);
    }

    @Override
    public void update(@NotNull String id, @NotNull List<String> lines) {
        CMIHologram hologram = this.cmiHologramManager.getByName(this.getHologramName(id));
        if (hologram == null) {
            throw new IllegalStateException("Cannot update hologram that does not exist: " + this.getHologramName(id));
        }
        hologram.setLines(lines);
        hologram.update();
    }

    @Override
    public void updateBulk(@NotNull Map<String, List<String>> hologramData) {
        for (Map.Entry<String, List<String>> entry : hologramData.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(@Nullable String id) {
        CMIHologram hologram = this.cmiHologramManager.getByName(this.getHologramName(id));
        if (hologram != null) {
            this.cmiHologramManager.removeHolo(hologram);
        }
        this.ourHologramIds.remove(id);
    }

    @Override
    public void removeAll() {
        for (String id : this.ourHologramIds) {
            CMIHologram hologram = this.cmiHologramManager.getByName(this.getHologramName(id));
            if (hologram == null) continue;
            this.cmiHologramManager.removeHolo(hologram);
        }
        this.ourHologramIds.clear();
        this.ourHologramIds.trimToSize();
    }

    private String getHologramName(String id) {
        if (this.hologramNamePrefix == null) {
            throw new IllegalStateException("Hook has not been activated yet");
        }
        return this.hologramNamePrefix + id;
    }
}

