/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.gui;

import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiHolder;
import com.craftaro.skyblock.core.gui.GuiManager;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.gui.methods.Clickable;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SimplePagedGui
extends Gui {
    protected boolean useHeader;
    private int rowsPerPage;
    private int maxCellSlot;
    protected ItemStack headerBackItem;
    protected ItemStack footerBackItem;
    final int nextPageIndex = 4;
    final int prevPageIndex = 6;

    public SimplePagedGui() {
        this((Gui)null);
    }

    public SimplePagedGui(Gui parent) {
        super(parent);
        this.nextPage = GuiUtils.createButtonItem(XMaterial.ARROW, "Next Page", new String[0]);
        this.prevPage = GuiUtils.createButtonItem(XMaterial.ARROW, "Previous Page", new String[0]);
    }

    public SimplePagedGui setUseHeader(boolean useHeader) {
        this.useHeader = useHeader;
        return this;
    }

    public ItemStack getHeaderBackItem() {
        return this.headerBackItem;
    }

    public SimplePagedGui setHeaderBackItem(ItemStack headerBackItem) {
        this.headerBackItem = headerBackItem;
        return this;
    }

    public ItemStack getFooterBackItem() {
        return this.footerBackItem;
    }

    public SimplePagedGui setFooterBackItem(ItemStack footerBackItem) {
        this.footerBackItem = footerBackItem;
        return this;
    }

    @Override
    @NotNull
    public SimplePagedGui setItem(int row, int col, ItemStack item) {
        return this.setItem(col + row * 9, item);
    }

    @Override
    @NotNull
    public SimplePagedGui setItem(int cell, ItemStack item) {
        int cellIndex = cell < 0 ? cell : (this.page == 1 || this.useHeader && cell < 9 ? cell : cell + (this.page - 1) * (this.rowsPerPage * 9));
        this.cellItems.put(cellIndex, item);
        if (this.open && cell >= 0 && cell < this.inventory.getSize()) {
            this.inventory.setItem(cell, item);
        }
        return this;
    }

    @Override
    public void nextPage() {
        if (this.page < this.pages) {
            ++this.page;
            this.showPage();
        }
    }

    @Override
    public void prevPage() {
        if (this.page > 1) {
            --this.page;
            this.showPage();
        }
    }

    public void showPage() {
        int startCell = this.useHeader ? 9 : 0;
        int cellIndex = startCell + (this.page - 1) * (this.rowsPerPage * 9);
        for (int i = startCell; i < (this.rows - 1) * 9; ++i) {
            ItemStack item;
            this.inventory.setItem(i, (item = (ItemStack)this.cellItems.get(cellIndex++)) != null ? item : this.blankItem);
        }
        this.updatePageNavigation();
    }

    @Override
    protected void updatePageNavigation() {
        if (this.page > 1) {
            this.inventory.setItem(this.inventory.getSize() - this.prevPageIndex, this.prevPage);
            this.setButton(-this.prevPageIndex, this.prevPage, ClickType.LEFT, (GuiClickEvent event) -> this.prevPage());
        } else {
            this.inventory.setItem(this.inventory.getSize() - this.prevPageIndex, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
            this.setItem(-this.prevPageIndex, null);
            this.clearActions(-this.prevPageIndex);
        }
        if (this.pages > 1 && this.page != this.pages) {
            this.inventory.setItem(this.inventory.getSize() - this.nextPageIndex, this.nextPage);
            this.setButton(-this.nextPageIndex, this.nextPage, ClickType.LEFT, (GuiClickEvent event) -> this.nextPage());
        } else {
            this.inventory.setItem(this.inventory.getSize() - this.nextPageIndex, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
            this.setItem(-this.nextPageIndex, null);
            this.clearActions(-this.nextPageIndex);
        }
    }

    @Override
    @NotNull
    protected Inventory generateInventory(@NotNull GuiManager manager) {
        this.guiManager = manager;
        this.rowsPerPage = this.useHeader ? 4 : 5;
        this.maxCellSlot = this.cellItems.keySet().stream().max(Integer::compare).orElse(0) + 1;
        int maxRows = (int)Math.ceil((double)this.maxCellSlot / 9.0);
        this.pages = (int)Math.max(1.0, Math.ceil((double)maxRows / (double)this.rowsPerPage));
        this.setRows(maxRows + (this.useHeader ? 1 : 0));
        this.createInventory();
        this.setPage(Math.min(this.page, this.pages));
        this.update();
        return this.inventory;
    }

    @Override
    protected void createInventory() {
        int cells = this.rows * 9;
        this.inventory = Bukkit.getServer().createInventory((InventoryHolder)new GuiHolder(this.guiManager, this), cells, this.title == null ? "" : SimplePagedGui.trimTitle(this.title));
    }

    @Override
    public void update() {
        if (this.inventory == null) {
            return;
        }
        this.rowsPerPage = this.useHeader ? 4 : 5;
        this.maxCellSlot = (this.cellItems.isEmpty() ? 0 : (Integer)this.cellItems.keySet().stream().max(Integer::compare).get()) + 1;
        int maxRows = Math.max(this.useHeader ? 1 : 0, (int)Math.ceil((double)this.maxCellSlot / 9.0));
        this.pages = (int)Math.ceil(maxRows / this.rowsPerPage);
        List<Player> toUpdate = null;
        if (Math.min(54, (maxRows + (this.useHeader ? 1 : 0)) * 9) != this.inventory.getSize()) {
            toUpdate = this.getPlayers();
            this.setRows(maxRows + (this.useHeader ? 1 : 0));
            this.createInventory();
        }
        if (this.useHeader) {
            for (int i = 0; i < 9; ++i) {
                ItemStack item = (ItemStack)this.cellItems.get(i);
                this.inventory.setItem(i, item != null ? item : (this.headerBackItem != null ? this.headerBackItem : this.blankItem));
            }
        }
        int cells = this.rows * 9;
        for (int i = cells - 9; i < cells; ++i) {
            this.inventory.setItem(i, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
        }
        this.showPage();
        if (toUpdate != null) {
            this.exit();
            toUpdate.forEach(player -> this.guiManager.showGUI((Player)player, this));
        }
    }

    @Override
    protected boolean onClick(@NotNull GuiManager manager, @NotNull Player player, @NotNull Inventory inventory, InventoryClickEvent event) {
        Clickable button;
        Map conditionals;
        int cell = event.getSlot();
        if (this.useHeader && cell < 9) {
            conditionals = (Map)this.conditionalButtons.get(cell);
        } else if (cell >= (this.rows - 1) * 9) {
            conditionals = (Map)this.conditionalButtons.get(cell - this.rows * 9);
        } else {
            int cellIndex = this.page == 1 ? cell : cell + (this.page - 1) * this.rowsPerPage * 9;
            conditionals = (Map)this.conditionalButtons.get(cellIndex);
        }
        if (conditionals == null || (button = (Clickable)conditionals.get(event.getClick())) == null && (button = (Clickable)conditionals.get(null)) == null) {
            return false;
        }
        button.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
        return true;
    }
}

