/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.gui;

import com.craftaro.skyblock.core.compatibility.ClientVersion;
import com.craftaro.skyblock.core.compatibility.ServerVersion;
import com.craftaro.skyblock.core.gui.AnvilGui;
import com.craftaro.skyblock.core.gui.BackgroundType;
import com.craftaro.skyblock.core.gui.Gui;
import com.craftaro.skyblock.core.gui.GuiHolder;
import com.craftaro.skyblock.core.gui.PopupMessage;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GuiManager {
    final Plugin plugin;
    final UUID uuid = UUID.randomUUID();
    final GuiListener listener = new GuiListener(this);
    final Map<Player, Gui> openInventories = new HashMap<Player, Gui>();
    private final Object lock = new Object();
    private boolean initialized = false;
    private boolean shutdown = false;

    public GuiManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void init() {
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        this.initialized = true;
        this.shutdown = false;
    }

    public boolean isClosed() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showGUI(Player player, Gui gui) {
        if (this.shutdown) {
            if (!this.plugin.isEnabled()) {
                return;
            }
            this.init();
        } else if (!this.initialized) {
            this.init();
        }
        if (gui instanceof AnvilGui) {
            Gui openInv = this.openInventories.get(player);
            if (openInv != null) {
                openInv.open = false;
            }
            gui.getOrCreateInventory(this);
            ((AnvilGui)gui).open();
            gui.onOpen(this, player);
            Object object = this.lock;
            synchronized (object) {
                this.openInventories.put(player, gui);
            }
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            Gui openInv = this.openInventories.get(player);
            if (openInv != null) {
                openInv.open = false;
            }
            Inventory inv = gui.getOrCreateInventory(this);
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                player.openInventory(inv);
                gui.onOpen(this, player);
                Object object = this.lock;
                synchronized (object) {
                    this.openInventories.put(player, gui);
                }
            });
        });
    }

    public void showPopup(Player player, String message) {
        this.showPopup(player, message, XMaterial.NETHER_STAR, BackgroundType.ADVENTURE);
    }

    public void showPopup(Player player, String message, XMaterial icon) {
        this.showPopup(player, message, icon, BackgroundType.ADVENTURE);
    }

    public void showPopup(Player player, String message, XMaterial icon, BackgroundType background) {
        if (ClientVersion.getClientVersion(player).isAtLeast(ServerVersion.V1_12)) {
            PopupMessage popup = new PopupMessage(this.plugin, icon, message, background);
            popup.add();
            popup.grant(player);
            Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, () -> {
                popup.revoke(player);
                popup.remove();
            }, 70L);
            return;
        }
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_11)) {
            player.sendTitle("", message, 10, 70, 10);
            return;
        }
        player.sendTitle("", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Object object = this.lock;
        synchronized (object) {
            this.openInventories.entrySet().stream().filter(e -> ((Player)e.getKey()).getOpenInventory().getTopInventory().getHolder() instanceof GuiHolder).collect(Collectors.toList()).forEach(e -> ((Player)e.getKey()).closeInventory());
            this.openInventories.clear();
        }
    }

    protected static class GuiListener
    implements Listener {
        final GuiManager manager;

        public GuiListener(GuiManager manager) {
            this.manager = manager;
        }

        @EventHandler(priority=EventPriority.LOW)
        void onDragGUI(InventoryDragEvent event) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Inventory openInv = event.getInventory();
            if (openInv.getHolder() != null && openInv.getHolder() instanceof GuiHolder && ((GuiHolder)openInv.getHolder()).manager.uuid.equals(this.manager.uuid)) {
                Gui gui = ((GuiHolder)openInv.getHolder()).getGUI();
                if (event.getRawSlots().stream().filter(slot -> gui.inventory.getSize() > slot).anyMatch(slot -> gui.unlockedCells.getOrDefault(slot, false) == false)) {
                    event.setCancelled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
        }

        @EventHandler(priority=EventPriority.LOW)
        void onClickGUI(InventoryClickEvent event) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Inventory openInv = event.getInventory();
            Player player = (Player)event.getWhoClicked();
            if (openInv.getHolder() != null && openInv.getHolder() instanceof GuiHolder && ((GuiHolder)openInv.getHolder()).manager.uuid.equals(this.manager.uuid)) {
                ItemStack clicked;
                Gui gui = ((GuiHolder)openInv.getHolder()).getGUI();
                if (event.getClick() == ClickType.DOUBLE_CLICK && (clicked = event.getCursor()) != null && clicked.getType() != Material.AIR) {
                    int cell = 0;
                    for (ItemStack it : gui.inventory.getContents()) {
                        if (gui.unlockedCells.getOrDefault(cell++, false).booleanValue() || !clicked.isSimilar(it)) continue;
                        event.setCancelled(true);
                        if (!(gui instanceof AnvilGui)) break;
                        ((AnvilGui)gui).anvil.update();
                        break;
                    }
                }
                if (event.getSlotType() == InventoryType.SlotType.OUTSIDE) {
                    if (!gui.onClickOutside(this.manager, player, event)) {
                        event.setCancelled(true);
                    }
                } else if (event.getRawSlot() < gui.inventory.getSize()) {
                    event.setCancelled(gui.unlockedCells.entrySet().stream().noneMatch(e -> event.getSlot() == ((Integer)e.getKey()).intValue() && (Boolean)e.getValue() != false));
                    if (gui.onClick(this.manager, player, openInv, event)) {
                        gui.getDefaultSound().play((Entity)player);
                    }
                } else if (gui.onClickPlayerInventory(this.manager, player, openInv, event)) {
                    gui.getDefaultSound().play((Entity)player);
                } else if (!gui.acceptsItems || event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                    event.setCancelled(true);
                    if (gui instanceof AnvilGui) {
                        ((AnvilGui)gui).anvil.update();
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.LOW)
        void onCloseGUI(InventoryCloseEvent event) {
            Inventory openInv = event.getInventory();
            if (openInv.getHolder() != null && openInv.getHolder() instanceof GuiHolder && ((GuiHolder)openInv.getHolder()).manager.uuid.equals(this.manager.uuid)) {
                Gui gui = ((GuiHolder)openInv.getHolder()).getGUI();
                if (gui instanceof AnvilGui) {
                    gui.inventory.clear();
                    gui.inventory = null;
                }
                if (!gui.open) {
                    return;
                }
                Player player = (Player)event.getPlayer();
                if (!gui.allowDropItems) {
                    player.setItemOnCursor(null);
                }
                if (this.manager.shutdown) {
                    gui.onClose(this.manager, player);
                } else {
                    Bukkit.getScheduler().runTaskLater(this.manager.plugin, () -> gui.onClose(this.manager, player), 1L);
                }
                this.manager.openInventories.remove(player);
            }
        }

        @EventHandler
        void onDisable(PluginDisableEvent event) {
            if (event.getPlugin() == this.manager.plugin) {
                this.manager.shutdown = true;
                this.manager.closeAll();
                this.manager.initialized = false;
            }
        }
    }
}

