/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.configuration.editor;

import com.craftaro.skyblock.core.configuration.editor.ConfigEditorGui;
import com.craftaro.skyblock.core.gui.GuiUtils;
import com.craftaro.skyblock.core.gui.SimplePagedGui;
import com.craftaro.skyblock.core.gui.events.GuiClickEvent;
import com.craftaro.skyblock.core.input.ChatPrompt;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.event.inventory.ClickType;

public class ConfigEditorListEditorGui
extends SimplePagedGui {
    final ConfigEditorGui current;
    public boolean saveChanges = false;
    public List<String> values;

    public ConfigEditorListEditorGui(ConfigEditorGui current, String key, List<String> val) {
        super(current);
        this.current = current;
        this.blankItem = current.getDefaultItem();
        this.headerBackItem = this.footerBackItem = current.getHeaderBackItem();
        this.setTitle(ChatColor.DARK_BLUE + "String List Editor");
        this.setUseHeader(true);
        this.setItem(4, current.configItem(XMaterial.FILLED_MAP, key, current.getCurrentNode(), key, null));
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_DOOR, "Exit", new String[0]), event -> event.player.closeInventory());
        this.values = new ArrayList<String>(val);
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.LAVA_BUCKET, ChatColor.RED + "Discard Changes", new String[0]), event -> event.player.closeInventory());
        this.setButton(0, GuiUtils.createButtonItem(XMaterial.REDSTONE, ChatColor.GREEN + "Save", new String[0]), event -> {
            this.saveChanges = true;
            event.player.closeInventory();
        });
        this.setButton(1, GuiUtils.createButtonItem(XMaterial.CHEST, ChatColor.BLUE + "Add Item", new String[0]), event -> {
            event.gui.exit();
            ChatPrompt.showPrompt(event.manager.getPlugin(), event.player, "Enter a new value to add:", response -> {
                this.values.add(response.getMessage().trim());
                this.redraw();
            }).setOnClose(() -> event.manager.showGUI(event.player, this)).setOnCancel(() -> {
                event.player.sendMessage(ChatColor.RED + "Edit canceled");
                event.manager.showGUI(event.player, this);
            });
        });
        this.redraw();
    }

    void redraw() {
        this.page = 1;
        if (this.inventory != null) {
            for (Integer i : this.cellItems.keySet().toArray(new Integer[0])) {
                if (i <= 8) continue;
                this.cellItems.remove(i);
                this.conditionalButtons.remove(i);
            }
        }
        int i = 9;
        for (String item : this.values) {
            int index = i - 9;
            this.setButton(i++, GuiUtils.createButtonItem(XMaterial.PAPER, item, "Right-click to remove"), ClickType.RIGHT, (GuiClickEvent event) -> {
                this.values.remove(index);
                this.redraw();
            });
        }
        this.update();
    }
}

