/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.compatibility;

import com.craftaro.third_party.org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;

public enum ServerProject {
    UNKNOWN,
    CRAFTBUKKIT,
    SPIGOT,
    PAPER,
    TACO,
    GLOWSTONE,
    MOCK_BUKKIT;

    private static final ServerProject serverProject;

    private static ServerProject checkProject() {
        String serverPath = Bukkit.getServer().getClass().getName();
        if (serverPath.equals("be.seeseemelk.mockbukkit.ServerMock")) {
            return MOCK_BUKKIT;
        }
        if (serverPath.contains("glowstone")) {
            return GLOWSTONE;
        }
        try {
            Class.forName("net.techcable.tacospigot.TacoSpigotConfig");
            return TACO;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.destroystokyo.paperclip.Paperclip");
                return PAPER;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("com.destroystokyo.paper.PaperConfig");
                    return PAPER;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        Class.forName("org.spigotmc.SpigotConfig");
                        return SPIGOT;
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        return serverPath.contains("craftbukkit") ? CRAFTBUKKIT : UNKNOWN;
                    }
                }
            }
        }
    }

    public static ServerProject getServerVersion() {
        return serverProject;
    }

    public static boolean isServer(ServerProject version) {
        return serverProject == version;
    }

    public static boolean isServer(ServerProject ... versions) {
        return ArrayUtils.contains((Object[])versions, (Object)((Object)serverProject));
    }

    static {
        serverProject = ServerProject.checkProject();
    }
}

