/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.compatibility;

import com.craftaro.skyblock.core.compatibility.ServerVersion;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LegacyParticleEffects {
    private static final String version = LegacyParticleEffects.getNMSVersion();
    private static boolean enabled = true;
    private static Class<?> mc_packetPlayOutWorldParticlesClazz;
    private static Class<?> cb_craftPlayerClazz;
    private static Method cb_craftPlayer_getHandle;
    private static Class<?> mc_entityPlayerClazz;
    private static Class<?> mc_playerConnectionClazz;
    private static Field mc_entityPlayer_playerConnection;
    private static Class<?> mc_PacketInterface;
    private static Method mc_playerConnection_sendPacket;
    private static Class<?> mc_EnumParticle;
    private static Method mc_EnumParticle_valueOf;

    private static String getNMSVersion() {
        String ver = Bukkit.getServer().getClass().getPackage().getName();
        return ver.substring(ver.lastIndexOf(46) + 1);
    }

    public static void createParticle(Location l, Type e) {
        LegacyParticleEffects.createParticle(l, e, 0.0f, 0.0f, 0.0f, 1.0f, 0, null);
    }

    public static void createParticle(Location l, Type e, List<Player> localOnly) {
        LegacyParticleEffects.createParticle(l, e, 0.0f, 0.0f, 0.0f, 1.0f, 0, localOnly);
    }

    public static void createParticle(Location l, Type e, float effectSpeed, int amountOfParticles) {
        LegacyParticleEffects.createParticle(l, e, 0.0f, 0.0f, 0.0f, effectSpeed, amountOfParticles, null);
    }

    public static void createParticle(Location l, Type e, float xx, float yy, float zz, float effectSpeed, int amountOfParticles, List<Player> localOnly) {
        if (!enabled || e == null || effectSpeed < 0.0f || amountOfParticles < 0 || !ServerVersion.isServerVersionAtLeast(e.minVersion) || e.maxVersion != null && !ServerVersion.isServerVersionBelow(e.maxVersion)) {
            return;
        }
        int rangeSquared = 256;
        ArrayList<Player> sendTo = new ArrayList<Player>();
        if (localOnly == null) {
            for (Player p : l.getWorld().getPlayers()) {
                if (!(p.getLocation().distanceSquared(l) <= 256.0)) continue;
                sendTo.add(p);
            }
        } else {
            World w = l.getWorld();
            for (Player p : localOnly) {
                if (p.getWorld() != w || !(p.getLocation().distanceSquared(l) <= 256.0)) continue;
                sendTo.add(p);
            }
        }
        if (sendTo.isEmpty()) {
            return;
        }
        try {
            Object sPacket = mc_packetPlayOutWorldParticlesClazz.newInstance();
            for (Field field : sPacket.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                if (fieldName.equals("a")) {
                    if (version.startsWith("v1_8")) {
                        field.set(sPacket, mc_EnumParticle_valueOf.invoke(null, e.name()));
                        continue;
                    }
                    field.set(sPacket, e.name);
                    continue;
                }
                if (fieldName.equals("b")) {
                    field.setFloat(sPacket, (float)l.getX());
                    continue;
                }
                if (fieldName.equals("c")) {
                    field.setFloat(sPacket, (float)l.getY());
                    continue;
                }
                if (fieldName.equals("d")) {
                    field.setFloat(sPacket, (float)l.getZ());
                    continue;
                }
                if (fieldName.equals("e")) {
                    field.setFloat(sPacket, xx);
                    continue;
                }
                if (fieldName.equals("f")) {
                    field.setFloat(sPacket, yy);
                    continue;
                }
                if (fieldName.equals("g")) {
                    field.setFloat(sPacket, zz);
                    continue;
                }
                if (fieldName.equals("h")) {
                    field.setFloat(sPacket, effectSpeed);
                    continue;
                }
                if (!fieldName.equals("i")) continue;
                field.setInt(sPacket, amountOfParticles);
            }
            for (Player p : sendTo) {
                LegacyParticleEffects.sendPacket(sPacket, p);
            }
        }
        catch (Throwable ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Problem preparing a particle packet (disabling further packets)", ex);
            enabled = false;
        }
    }

    @Deprecated
    private static void sendPacket(Object packet, Player to) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object cbPlayer = cb_craftPlayer_getHandle.invoke((Object)to, new Object[0]);
        Object mcConnection = mc_entityPlayer_playerConnection.get(cbPlayer);
        mc_playerConnection_sendPacket.invoke(mcConnection, packet);
    }

    static {
        try {
            mc_packetPlayOutWorldParticlesClazz = !version.startsWith("v1_7") && !version.startsWith("v1_8") ? Class.forName("net.minecraft.server." + version + ".Packet63WorldParticles") : Class.forName("net.minecraft.server." + version + ".PacketPlayOutWorldParticles");
            cb_craftPlayerClazz = Class.forName("org.bukkit.craftbukkit." + version + ".entity.CraftPlayer");
            cb_craftPlayer_getHandle = cb_craftPlayerClazz.getDeclaredMethod("getHandle", new Class[0]);
            mc_entityPlayerClazz = Class.forName("net.minecraft.server." + version + ".EntityPlayer");
            mc_entityPlayer_playerConnection = mc_entityPlayerClazz.getDeclaredField("playerConnection");
            mc_playerConnectionClazz = Class.forName("net.minecraft.server." + version + ".PlayerConnection");
            mc_PacketInterface = Class.forName("net.minecraft.server." + version + ".Packet");
            mc_playerConnection_sendPacket = mc_playerConnectionClazz.getDeclaredMethod(ServerVersion.isServerVersion(ServerVersion.V1_18) ? "a" : "sendPacket", mc_PacketInterface);
            if (version.startsWith("v1_8")) {
                mc_EnumParticle = Class.forName("net.minecraft.server." + version + ".EnumParticle");
                mc_EnumParticle_valueOf = mc_EnumParticle.getDeclaredMethod("valueOf", String.class);
            }
        }
        catch (Throwable ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Problem preparing particle packets (disabling further packets)", ex);
            enabled = false;
        }
    }

    public static enum Type {
        EXPLOSION_NORMAL("explode"),
        EXPLOSION_LARGE("largeexplode"),
        EXPLOSION_HUGE("hugeexplosion"),
        FIREWORKS_SPARK("fireworksSpark"),
        WATER_BUBBLE("bubble"),
        WATER_SPLASH("splash"),
        WATER_WAKE("wake", ServerVersion.V1_8),
        SUSPENDED("suspended"),
        SUSPENDED_DEPTH("depthsuspend"),
        CRIT("crit"),
        CRIT_MAGIC("magicCrit"),
        SMOKE_NORMAL("smoke"),
        SMOKE_LARGE("largesmoke"),
        SPELL("spell"),
        SPELL_INSTANT("instantSpell"),
        SPELL_MOB("mobSpell"),
        SPELL_MOB_AMBIENT("mobSpellAmbient"),
        SPELL_WITCH("witchMagic"),
        DRIP_WATER("dripWater"),
        DRIP_LAVA("dripLava"),
        VILLAGER_ANGRY("angryVillager"),
        VILLAGER_HAPPY("happyVillager"),
        TOWN_AURA("townaura"),
        NOTE("note"),
        PORTAL("portal"),
        ENCHANTMENT_TABLE("enchantmenttable"),
        FLAME("flame"),
        LAVA("lava"),
        FOOTSTEP("footstep"),
        CLOUD("cloud"),
        REDSTONE("reddust"),
        SNOWBALL("snowballpoof"),
        SNOW_SHOVEL("snowshovel"),
        SLIME("slime"),
        HEART("heart"),
        BARRIER("barrier", ServerVersion.V1_8),
        ITEM_CRACK("iconcrack_"),
        BLOCK_CRACK("blockcrack_", ServerVersion.V1_8),
        BLOCK_DUST("blockdust_", ServerVersion.V1_8),
        WATER_DROP("droplet", ServerVersion.V1_8),
        ITEM_TAKE("take", ServerVersion.V1_8),
        MOB_APPEARANCE("mobappearance", ServerVersion.V1_8),
        TOOL_BREAK("tilecrack_", ServerVersion.UNKNOWN, ServerVersion.V1_7);

        public final String name;
        public final ServerVersion minVersion;
        public final ServerVersion maxVersion;

        private Type(String name) {
            this.name = name;
            this.minVersion = ServerVersion.UNKNOWN;
            this.maxVersion = null;
        }

        private Type(String name, ServerVersion minVersion) {
            this.name = name;
            this.minVersion = minVersion;
            this.maxVersion = null;
        }

        private Type(String name, ServerVersion minVersion, ServerVersion maxVersion) {
            this.name = name;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        }

        public static Type getById(String id) {
            for (Type t : Type.values()) {
                if (!t.name.equalsIgnoreCase(id) && !t.name().equalsIgnoreCase(id)) continue;
                return t;
            }
            return null;
        }
    }
}

