/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core.compatibility;

import com.craftaro.skyblock.core.compatibility.ServerVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum CompatibleHand {
    MAIN_HAND,
    OFF_HAND;

    private static final Map<String, Method> methodCache;

    public static CompatibleHand getHand(Object event) {
        try {
            Method method;
            Class<?> clazz = event.getClass();
            String className = clazz.getName();
            if (methodCache.containsKey(className)) {
                method = methodCache.get(className);
            } else {
                method = clazz.getDeclaredMethod("getHand", new Class[0]);
                methodCache.put(className, method);
            }
            EquipmentSlot slot = (EquipmentSlot)method.invoke(event, new Object[0]);
            if (slot == EquipmentSlot.OFF_HAND) {
                return OFF_HAND;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return MAIN_HAND;
    }

    public static CompatibleHand getHand(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.HAND ? MAIN_HAND : OFF_HAND;
    }

    public void takeItem(LivingEntity entity) {
        this.takeItem(entity, 1);
    }

    public void takeItem(LivingEntity entity, int amount) {
        ItemStack item = this == MAIN_HAND ? entity.getEquipment().getItemInHand() : entity.getEquipment().getItemInOffHand();
        int result = item.getAmount() - amount;
        item.setAmount(result);
        if (this == MAIN_HAND) {
            entity.getEquipment().setItemInHand((ItemStack)(result > 0 ? item : null));
            return;
        }
        entity.getEquipment().setItemInOffHand((ItemStack)(result > 0 ? item : null));
    }

    public ItemStack getItem(LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return null;
        }
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_9)) {
            return equipment.getItemInHand();
        }
        if (this == MAIN_HAND) {
            return equipment.getItemInMainHand();
        }
        return equipment.getItemInOffHand();
    }

    public void setItem(LivingEntity entity, ItemStack item) {
        if (this == MAIN_HAND) {
            entity.getEquipment().setItemInHand(item);
            return;
        }
        entity.getEquipment().setItemInOffHand(item);
    }

    static {
        methodCache = new HashMap<String, Method>();
    }
}

