/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.core;

import com.craftaro.skyblock.core.SongodaCore;
import com.craftaro.skyblock.core.configuration.Config;
import com.craftaro.skyblock.core.database.DataManager;
import com.craftaro.skyblock.core.database.DataMigration;
import com.craftaro.skyblock.core.database.DatabaseType;
import com.craftaro.skyblock.core.dependency.Dependency;
import com.craftaro.skyblock.core.dependency.DependencyLoader;
import com.craftaro.skyblock.core.dependency.Relocation;
import com.craftaro.skyblock.core.hooks.HookRegistryManager;
import com.craftaro.skyblock.core.locale.Locale;
import com.craftaro.skyblock.core.third_party.de.tr7zw.nbtapi.utils.MinecraftVersion;
import com.craftaro.skyblock.core.utils.Metrics;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class SongodaPlugin
extends JavaPlugin {
    protected Locale locale;
    protected Config config;
    protected Config databaseConfig;
    protected DataManager dataManager;
    protected long dataLoadDelay = 20L;
    private boolean emergencyStop = false;
    private final HookRegistryManager hookRegistryManager = new HookRegistryManager((Plugin)this);

    @NotNull
    protected Set<Dependency> getDependencies() {
        return Collections.emptySet();
    }

    public abstract void onPluginLoad();

    public abstract void onPluginEnable();

    public abstract void onPluginDisable();

    public abstract void onDataLoad();

    public abstract void onConfigReload();

    public abstract List<Config> getExtraConfig();

    @NotNull
    public FileConfiguration getConfig() {
        return this.config.getFileConfig();
    }

    public Config getCoreConfig() {
        return this.config;
    }

    public void reloadConfig() {
        this.config.load();
        this.onConfigReload();
    }

    public void saveConfig() {
        this.config.save();
    }

    public final void onLoad() {
        SongodaCore.getLogger().setPlugin((Plugin)this);
        try {
            HashSet<Dependency> dependencies = new HashSet<Dependency>(this.getDependencies());
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;apache;commons", "commons-text", "1.12.0"));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;apache;commons", "commons-lang3", "3.14.0"));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;slf4j", "slf4j-api", "2.0.11", false));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "com;zaxxer", "HikariCP", "4.0.3"));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;reactivestreams", "reactive-streams", "1.0.2", true));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;jooq", "jooq", "3.14.16", true, new Relocation("org;reactivestreams", "com;craftaro;third_party;org;reactivestreams")));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "org;mariadb;jdbc", "mariadb-java-client", "3.2.0"));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "com;h2database", "h2", "1.4.200", false, new Relocation("org;h2", "com;craftaro;third_party;org;h2")));
            dependencies.add(new Dependency("https://repo1.maven.org/maven2", "com;github;cryptomorin", "XSeries", "11.2.1", false, new Relocation("com;cryptomorin;xseries", "com;craftaro;third_party;com;cryptomorin;xseries")));
            new DependencyLoader((Plugin)this).loadDependencies(dependencies);
            this.config = new Config((Plugin)this);
            this.onPluginLoad();
        }
        catch (Throwable th) {
            this.criticalErrorOnPluginStartup(th);
        }
    }

    public final void onEnable() {
        if (this.emergencyStop) {
            this.setEnabled(false);
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage(" ");
        console.sendMessage(ChatColor.GREEN + "=============================");
        console.sendMessage(String.format("%s%s %s by %sSongoda <3!", ChatColor.GRAY, this.getDescription().getName(), this.getDescription().getVersion(), ChatColor.DARK_PURPLE));
        console.sendMessage(String.format("%sAction: %s%s%s...", ChatColor.GRAY, ChatColor.GREEN, "Enabling", ChatColor.GRAY));
        try {
            this.locale = Locale.loadDefaultLocale(this, "en_US");
            this.onPluginEnable();
            if (this.emergencyStop) {
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this, this::onDataLoad, this.dataLoadDelay);
            if (this.emergencyStop) {
                console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                console.sendMessage(" ");
                return;
            }
            Metrics.start((Plugin)this);
        }
        catch (Throwable th) {
            this.criticalErrorOnPluginStartup(th);
            console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            console.sendMessage(" ");
            return;
        }
        console.sendMessage(ChatColor.GREEN + "=============================");
        console.sendMessage(" ");
    }

    public final void onDisable() {
        if (this.emergencyStop) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage(" ");
        console.sendMessage(ChatColor.GREEN + "=============================");
        console.sendMessage(String.format("%s%s %s by %sSongoda <3!", ChatColor.GRAY, this.getDescription().getName(), this.getDescription().getVersion(), ChatColor.DARK_PURPLE));
        console.sendMessage(String.format("%sAction: %s%s%s...", ChatColor.GRAY, ChatColor.RED, "Disabling", ChatColor.GRAY));
        this.onPluginDisable();
        try (Connection connection = this.dataManager.getDatabaseConnector().getConnection();){
            connection.close();
            this.dataManager.getDatabaseConnector().closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hookRegistryManager.deactivateAllActiveHooks();
        console.sendMessage(ChatColor.GREEN + "=============================");
        console.sendMessage(" ");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean setLocale(String localeName, boolean reload) {
        if (this.locale != null && this.locale.getName().equals(localeName)) {
            return !reload || this.locale.reloadMessages();
        }
        Locale loadedLocale = Locale.loadLocale(this, localeName);
        if (loadedLocale != null) {
            this.locale = loadedLocale;
            return true;
        }
        return false;
    }

    protected void emergencyStop() {
        this.emergencyStop = true;
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    protected void criticalErrorOnPluginStartup(Throwable throwable) {
        Bukkit.getLogger().log(Level.SEVERE, String.format("Unexpected error while loading %s v%s (core v%s): Disabling plugin!", this.getDescription().getName(), this.getDescription().getVersion(), SongodaCore.getVersion()), throwable);
        this.emergencyStop();
    }

    public Config getDatabaseConfig() {
        File databaseFile = new File(this.getDataFolder(), "database.yml");
        if (!databaseFile.exists()) {
            this.saveResource("database.yml", false);
        }
        if (this.databaseConfig == null) {
            this.databaseConfig = new Config(databaseFile);
            this.databaseConfig.load();
        }
        return this.databaseConfig;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    protected void initDatabase() {
        this.initDatabase(Collections.emptyList());
    }

    protected void initDatabase(DataMigration ... migrations) {
        this.initDatabase(Arrays.asList(migrations));
    }

    protected void initDatabase(List<DataMigration> migrations) {
        File databaseFile = new File(this.getDataFolder(), this.getName().toLowerCase() + ".db");
        boolean legacy = databaseFile.exists();
        if (legacy) {
            this.getLogger().warning("SQLite detected, converting to H2...");
            this.dataManager = new DataManager(this, migrations, DatabaseType.SQLITE);
        } else {
            this.dataManager = new DataManager(this, migrations);
        }
        if (this.dataManager.getDatabaseConnector().isInitialized() && this.dataManager.getDatabaseConnector().getType() == DatabaseType.SQLITE) {
            try {
                DataManager newDataManager = DataMigration.convert(this, DatabaseType.H2);
                if (newDataManager != null && newDataManager.getDatabaseConnector().isInitialized()) {
                    this.setDataManager(newDataManager);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void setDataManager(DataManager dataManager) {
        if (dataManager == null) {
            throw new IllegalArgumentException("DataManager cannot be null!");
        }
        if (this.dataManager == dataManager) {
            return;
        }
        if (this.dataManager != null) {
            this.dataManager.shutdown();
        }
        this.dataManager = dataManager;
    }

    public HookRegistryManager getHookManager() {
        return this.hookRegistryManager;
    }

    static {
        MinecraftVersion.getLogger().setLevel(Level.WARNING);
        MinecraftVersion.disableUpdateCheck();
        System.setProperty("com.craftaro.third_party.org.jooq.no-tips", "true");
        System.setProperty("com.craftaro.third_party.org.jooq.no-logo", "true");
    }
}

