/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.cooldown;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.cooldown.Cooldown;
import com.craftaro.skyblock.cooldown.CooldownPlayer;
import com.craftaro.skyblock.cooldown.CooldownTask;
import com.craftaro.skyblock.cooldown.CooldownType;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CooldownManager {
    private final SkyBlock plugin;
    private final Map<CooldownType, List<CooldownPlayer>> cooldownStorage = new EnumMap<CooldownType, List<CooldownPlayer>>(CooldownType.class);

    public CooldownManager(SkyBlock plugin) {
        this.plugin = plugin;
        IslandManager islandManager = plugin.getIslandManager();
        for (CooldownType cooldownTypeList : CooldownType.getTypes()) {
            ArrayList<CooldownPlayer> cooldownPlayers = new ArrayList<CooldownPlayer>();
            for (Player all : Bukkit.getOnlinePlayers()) {
                OfflinePlayer offlinePlayer;
                Island island;
                CooldownPlayer cooldownPlayer = null;
                if (cooldownTypeList == CooldownType.BIOME || cooldownTypeList == CooldownType.CREATION || cooldownTypeList == CooldownType.DELETION) {
                    cooldownPlayer = this.loadCooldownPlayer(cooldownTypeList, (OfflinePlayer)all);
                } else if (!(cooldownTypeList != CooldownType.LEVELLING && cooldownTypeList != CooldownType.OWNERSHIP || (island = islandManager.getIsland((OfflinePlayer)all)) == null || this.hasPlayer(cooldownTypeList, offlinePlayer = Bukkit.getServer().getOfflinePlayer(island.getOwnerUUID())))) {
                    cooldownPlayer = this.loadCooldownPlayer(cooldownTypeList, offlinePlayer);
                }
                if (cooldownPlayer == null) continue;
                cooldownPlayers.add(cooldownPlayer);
            }
            this.cooldownStorage.put(cooldownTypeList, cooldownPlayers);
        }
        new CooldownTask(this).runTaskTimerAsynchronously((Plugin)plugin, 0L, 20L);
    }

    public void onDisable() {
        for (CooldownType cooldownTypeList : CooldownType.getTypes()) {
            this.setCooldownPlayer(cooldownTypeList);
            this.saveCooldownPlayer(cooldownTypeList);
        }
    }

    public CooldownPlayer loadCooldownPlayer(CooldownType cooldownType, OfflinePlayer player) {
        FileManager.Config config;
        FileConfiguration configLoad;
        if (cooldownType == CooldownType.BIOME || cooldownType == CooldownType.CREATION || cooldownType == CooldownType.DELETION) {
            FileManager.Config config2 = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "player-data"), player.getUniqueId() + ".yml"));
            FileConfiguration configLoad2 = config2.getFileConfiguration();
            if (configLoad2.getString("Island." + cooldownType.getFriendlyName() + ".Cooldown") != null) {
                return new CooldownPlayer(player.getUniqueId(), new Cooldown(configLoad2.getInt("Island." + cooldownType.getFriendlyName() + ".Cooldown")));
            }
        } else if ((cooldownType == CooldownType.LEVELLING || cooldownType == CooldownType.OWNERSHIP) && (configLoad = (config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), player.getUniqueId() + ".yml"))).getFileConfiguration()).getString(cooldownType.getFriendlyName() + ".Cooldown") != null) {
            return new CooldownPlayer(player.getUniqueId(), new Cooldown(configLoad.getInt(cooldownType.getFriendlyName() + ".Cooldown")));
        }
        return null;
    }

    public void createPlayer(CooldownType cooldownType, OfflinePlayer player) {
        FileManager fileManager = this.plugin.getFileManager();
        List<CooldownPlayer> cooldowns = this.cooldownStorage.get((Object)cooldownType);
        if (cooldowns == null) {
            return;
        }
        int time = 0;
        if (cooldownType == CooldownType.BIOME || cooldownType == CooldownType.CREATION || cooldownType == CooldownType.DELETION || cooldownType == CooldownType.PREVIEW) {
            time = this.plugin.getConfiguration().getInt("Island." + cooldownType.getFriendlyName() + ".Cooldown.Time");
            FileManager.Config config = fileManager.getConfig(new File(new File(this.plugin.getDataFolder(), "player-data"), player.getUniqueId() + ".yml"));
            File configFile = config.getFile();
            FileConfiguration configLoad = config.getFileConfiguration();
            configLoad.set("Island." + cooldownType.getFriendlyName() + ".Cooldown", (Object)time);
            try {
                configLoad.save(configFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (cooldownType == CooldownType.LEVELLING || cooldownType == CooldownType.OWNERSHIP) {
            time = this.plugin.getConfiguration().getInt("Island." + cooldownType.getFriendlyName() + ".Cooldown.Time");
            FileManager.Config config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), player.getUniqueId() + ".yml"));
            File configFile = config.getFile();
            FileConfiguration configLoad = config.getFileConfiguration();
            configLoad.set(cooldownType.getFriendlyName() + ".Cooldown", (Object)time);
            try {
                configLoad.save(configFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        cooldowns.add(new CooldownPlayer(player.getUniqueId(), new Cooldown(time)));
    }

    public void deletePlayer(CooldownType cooldownType, OfflinePlayer player) {
        Iterator<CooldownPlayer> it = this.getCooldownPlayersOrEmptyList(cooldownType).iterator();
        while (it.hasNext()) {
            if (!it.next().getUUID().equals(player.getUniqueId())) continue;
            if (cooldownType == CooldownType.BIOME || cooldownType == CooldownType.CREATION || cooldownType == CooldownType.DELETION) {
                this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder().toString() + "/player-data"), player.getUniqueId().toString() + ".yml")).getFileConfiguration().set("Island." + cooldownType.getFriendlyName() + ".Cooldown", null);
            } else if (cooldownType == CooldownType.LEVELLING || cooldownType == CooldownType.OWNERSHIP) {
                this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder() + "/island-data"), player.getUniqueId() + ".yml")).getFileConfiguration().set(cooldownType.getFriendlyName() + ".Cooldown", null);
            }
            it.remove();
            break;
        }
    }

    public boolean hasPlayer(CooldownType cooldownType, OfflinePlayer player) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            if (!cooldownPlayerList.getUUID().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public void transferPlayer(CooldownType cooldownType, OfflinePlayer player1, OfflinePlayer player2) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            if (!cooldownPlayerList.getUUID().equals(player1.getUniqueId())) continue;
            cooldownPlayerList.setUUID(player2.getUniqueId());
            break;
        }
    }

    public void removeCooldownPlayer(CooldownType cooldownType, CooldownPlayer cooldownPlayer) {
        this.getCooldownPlayersOrEmptyList(cooldownType).remove(cooldownPlayer);
    }

    public void removeCooldownPlayer(CooldownType cooldownType, OfflinePlayer player) {
        Iterator<CooldownPlayer> it = this.getCooldownPlayersOrEmptyList(cooldownType).iterator();
        while (it.hasNext()) {
            if (!it.next().getUUID().equals(player.getUniqueId())) continue;
            it.remove();
            break;
        }
    }

    public void setCooldownPlayer(CooldownType cooldownType) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            this.setCooldownPlayer(cooldownType, Bukkit.getServer().getOfflinePlayer(cooldownPlayerList.getUUID()));
        }
    }

    public void setCooldownPlayer(CooldownType cooldownType, OfflinePlayer player) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            if (!cooldownPlayerList.getUUID().equals(player.getUniqueId())) continue;
            if (cooldownType == CooldownType.BIOME || cooldownType == CooldownType.CREATION || cooldownType == CooldownType.DELETION) {
                this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder() + "/player-data"), player.getUniqueId() + ".yml")).getFileConfiguration().set("Island." + (Object)((Object)cooldownType) + ".Cooldown", (Object)cooldownPlayerList.getCooldown().getTime());
                break;
            }
            if (cooldownType != CooldownType.LEVELLING && cooldownType != CooldownType.OWNERSHIP) break;
            this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder(), "island-data"), player.getUniqueId() + ".yml")).getFileConfiguration().set(cooldownType.getFriendlyName() + ".Cooldown", (Object)cooldownPlayerList.getCooldown().getTime());
            break;
        }
    }

    public void saveCooldownPlayer(CooldownType cooldownType) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            this.saveCooldownPlayer(cooldownType, Bukkit.getServer().getOfflinePlayer(cooldownPlayerList.getUUID()));
        }
    }

    public void saveCooldownPlayer(CooldownType cooldownType, OfflinePlayer player) {
        FileManager.Config config = null;
        if (cooldownType == CooldownType.BIOME || cooldownType == CooldownType.CREATION || cooldownType == CooldownType.DELETION) {
            config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder().toString() + "/player-data"), player.getUniqueId().toString() + ".yml"));
        } else if (cooldownType == CooldownType.LEVELLING || cooldownType == CooldownType.OWNERSHIP) {
            config = this.plugin.getFileManager().getConfig(new File(new File(this.plugin.getDataFolder().toString() + "/island-data"), player.getUniqueId().toString() + ".yml"));
        }
        if (config != null) {
            try {
                config.getFileConfiguration().save(config.getFile());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addCooldownPlayer(CooldownType cooldownType, CooldownPlayer cooldownPlayer) {
        if (cooldownType == null || cooldownPlayer == null) {
            return;
        }
        List<CooldownPlayer> cooldowns = this.cooldownStorage.get((Object)cooldownType);
        if (cooldowns == null) {
            return;
        }
        cooldowns.add(cooldownPlayer);
    }

    public CooldownPlayer getCooldownPlayer(CooldownType cooldownType, OfflinePlayer player) {
        for (CooldownPlayer cooldownPlayerList : this.getCooldownPlayersOrEmptyList(cooldownType)) {
            if (!cooldownPlayerList.getUUID().equals(player.getUniqueId())) continue;
            return cooldownPlayerList;
        }
        return null;
    }

    public List<CooldownPlayer> getCooldownPlayers(CooldownType cooldownType) {
        return this.cooldownStorage.get((Object)cooldownType);
    }

    public List<CooldownPlayer> getCooldownPlayersOrEmptyList(CooldownType cooldownType) {
        return this.cooldownStorage.getOrDefault((Object)cooldownType, Collections.emptyList());
    }

    public boolean hasCooldownType(CooldownType cooldownType) {
        return this.cooldownStorage.containsKey((Object)cooldownType);
    }
}

