/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WhitelistCommand
extends SubCommand {
    public WhitelistCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        FileManager fileManager = this.plugin.getFileManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager.Config language = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration languageLoad = language.getFileConfiguration();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (island == null) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Whitelist.Owner.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else if (island.hasRole(IslandRole.OWNER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && this.plugin.getPermissionManager().hasPermission(island, "Visitor", IslandRole.OPERATOR)) {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("on")) {
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.Enabled.Message"));
                    islandManager.whitelistIsland(island);
                } else if (args[0].equalsIgnoreCase("off")) {
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.Disabled.Message"));
                    islandManager.closeIsland(island);
                } else if (args[0].equalsIgnoreCase("list")) {
                    Set<UUID> whitelistedPlayers = island.getWhitelistedPlayers();
                    if (!whitelistedPlayers.isEmpty()) {
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.List.Start.Message"));
                        for (UUID uuid : whitelistedPlayers) {
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.List.List.Message").replace("%player", new com.craftaro.skyblock.utils.player.OfflinePlayer(uuid).getName()));
                        }
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.List.End.Message"));
                    } else {
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.List.Empty.Message"));
                    }
                } else {
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.InvalidArgNumber.Message"));
                }
            } else if (args.length == 2) {
                com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(args[1]);
                if (offlinePlayer.getBukkitOfflinePlayer().hasPlayedBefore()) {
                    if (args[0].equalsIgnoreCase("add")) {
                        if (!island.isPlayerWhitelisted(offlinePlayer.getUUID())) {
                            island.addWhitelistedPlayer(offlinePlayer.getUUID());
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.Added.Message").replace("%player", offlinePlayer.getName()));
                        } else {
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.AlreadyAdded.Message").replace("%player", offlinePlayer.getName()));
                        }
                    } else if (args[0].equalsIgnoreCase("remove")) {
                        if (island.isPlayerWhitelisted(offlinePlayer.getUUID())) {
                            island.removeWhitelistedPlayer(offlinePlayer.getUUID());
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.Removed.Message").replace("%player", offlinePlayer.getName()));
                        } else {
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.NotWhitelisted.Message").replace("%player", offlinePlayer.getName()));
                        }
                    } else {
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.InvalidArgNumber.Message"));
                    }
                } else {
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.PlayerNotFound.Message").replace("%player", offlinePlayer.getName()));
                }
            } else {
                messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Whitelist.InvalidArgNumber.Message"));
            }
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Whitelist.Permission.Message"));
            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Public.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[]{"on", "off", "add", "remove", "list"};
    }
}

