/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.menus.Visit;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VisitCommand
extends SubCommand {
    public VisitCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        if (args.length == 0) {
            if (!this.plugin.getPlayerDataManager().hasPlayerData(player)) {
                this.plugin.getPlayerDataManager().createPlayerData(player);
            }
            PlayerData playerData = this.plugin.getPlayerDataManager().getPlayerData(player);
            playerData.setType((Object)Visit.Type.DEFAULT);
            playerData.setSort((Object)Visit.Sort.DEFAULT);
            Visit.getInstance().open(player, (Visit.Type)((Object)playerData.getType()), (Visit.Sort)((Object)playerData.getSort()));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_OPEN);
        } else if (args.length == 1) {
            Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getServer().dispatchCommand((CommandSender)player, "island teleport " + args[0]));
        } else {
            messageManager.sendMessage((CommandSender)player, this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml")).getFileConfiguration().getString("Command.Island.Visit.Invalid.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "visit";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Visit.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"warps", "explore"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

