/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.skyblock.visit.Visit;
import com.craftaro.skyblock.visit.VisitManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeleportCommand
extends SubCommand {
    public TeleportCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        Island island;
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        VisitManager visitManager = this.plugin.getVisitManager();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (args.length == 1) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
            Island island2 = islandManager.getIsland(offlinePlayer);
            if (island2 == null) {
                String commandToExecute;
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Island.None.Message", "Command.Island.Teleport.Island.None.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                if (this.plugin.getIslandManager().getIsland((OfflinePlayer)player) == null && !(commandToExecute = configLoad.getString("Command.IslandTeleport.Aliases.NoIsland", "")).isEmpty()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)commandToExecute);
                }
                return;
            }
            UUID islandOwnerUUID = island2.getOwnerUUID();
            if (islandOwnerUUID == null) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Island.None.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
            if (!islandOwnerUUID.equals(playerDataManager.getPlayerData(player).getOwner())) {
                if (visitManager.hasIsland(islandOwnerUUID)) {
                    Visit visit = visitManager.getIsland(islandOwnerUUID);
                    boolean isCoopPlayer = false;
                    boolean isWhitelistedPlayer = false;
                    if (islandManager.containsIsland(islandOwnerUUID)) {
                        if (islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(islandOwnerUUID)).isCoopPlayer(player.getUniqueId())) {
                            isCoopPlayer = true;
                        }
                        if (visit.getStatus() == IslandStatus.WHITELISTED && islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(islandOwnerUUID)).isPlayerWhitelisted(player.getUniqueId())) {
                            isWhitelistedPlayer = true;
                        }
                    }
                    if (visit.getStatus() == IslandStatus.OPEN || isCoopPlayer || isWhitelistedPlayer || player.hasPermission("fabledskyblock.bypass") || player.hasPermission("fabledskyblock.bypass.*") || player.hasPermission("fabledskyblock.*")) {
                        if (!islandManager.containsIsland(islandOwnerUUID)) {
                            islandManager.loadIsland(Bukkit.getServer().getOfflinePlayer(islandOwnerUUID));
                        }
                        islandManager.visitIsland(player, islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(islandOwnerUUID)));
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Teleported.Other.Message").replace("%player", args[0]));
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
                        return;
                    }
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Island.Closed.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Island.None.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
        } else if (args.length != 0) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Invalid.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            return;
        }
        if ((island = islandManager.getIsland((OfflinePlayer)player)) == null) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Owner.Message", "Command.Island.Teleport.Owner.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Teleport.Teleported.Yourself.Message", "Command.Island.Teleport.Teleported.Yourself.Message"));
            soundManager.playSound((CommandSender)player, XSound.ENTITY_ENDERMAN_TELEPORT);
            Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                Location loc = island.getLocation(IslandWorld.NORMAL, IslandEnvironment.MAIN);
                PaperLib.getChunkAtAsync(loc).thenRun(() -> {
                    if (this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "config.yml")).getFileConfiguration().getBoolean("Island.Teleport.RemoveWater", false)) {
                        LocationUtil.removeWaterFromLoc(loc);
                    }
                    PaperLib.teleportAsync((Entity)player, loc);
                });
                if (!configLoad.getBoolean("Island.Teleport.FallDamage", true)) {
                    player.setFallDistance(0.0f);
                }
            });
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Teleport.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"tp", "spawn", "home", "go", "warp"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

