/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.player.PlayerIslandLeaveEvent;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.scoreboard.ScoreboardManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LeaveCommand
extends SubCommand {
    public LeaveCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        PlayerData playerData = playerDataManager.getPlayerData(player);
        FileManager.Config languageConfig = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (island == null) {
            messageManager.sendMessage((CommandSender)player, languageConfig.getFileConfiguration().getString("Command.Island.Leave.Member.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            messageManager.sendMessage((CommandSender)player, languageConfig.getFileConfiguration().getString("Command.Island.Leave.Owner.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else {
            PlayerIslandLeaveEvent islandLeaveEvent = new PlayerIslandLeaveEvent(player, island.getAPIWrapper());
            Bukkit.getServer().getPluginManager().callEvent((Event)islandLeaveEvent);
            if (!islandLeaveEvent.isCancelled()) {
                if (islandManager.isPlayerAtIsland(island, player)) {
                    LocationUtil.teleportPlayerToSpawn(player);
                }
                if (island.hasRole(IslandRole.MEMBER, player.getUniqueId())) {
                    island.removeRole(IslandRole.MEMBER, player.getUniqueId());
                } else if (island.hasRole(IslandRole.OPERATOR, player.getUniqueId())) {
                    island.removeRole(IslandRole.OPERATOR, player.getUniqueId());
                }
                island.save();
                playerData.setPlaytime(0);
                playerData.setOwner(null);
                playerData.setMemberSince(null);
                playerData.setChat(false);
                playerData.save();
                Set<UUID> islandMembersOnline = islandManager.getMembersOnline(island);
                if (islandMembersOnline.size() == 1) {
                    for (UUID islandMembersOnlineList : islandMembersOnline) {
                        Player targetPlayer;
                        PlayerData targetPlayerData;
                        if (islandMembersOnlineList.equals(player.getUniqueId()) || !(targetPlayerData = playerDataManager.getPlayerData(targetPlayer = Bukkit.getServer().getPlayer(islandMembersOnlineList))).isChat()) continue;
                        targetPlayerData.setChat(false);
                        messageManager.sendMessage((CommandSender)targetPlayer, fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml")).getFileConfiguration().getString("Island.Chat.Untoggled.Message"));
                    }
                }
                islandManager.unloadIsland(island, null);
                for (Player loopPlayer : Bukkit.getOnlinePlayers()) {
                    if (loopPlayer.getUniqueId().equals(player.getUniqueId()) || !island.hasRole(IslandRole.MEMBER, loopPlayer.getUniqueId()) && !island.hasRole(IslandRole.OPERATOR, loopPlayer.getUniqueId()) && !island.hasRole(IslandRole.OWNER, loopPlayer.getUniqueId())) continue;
                    loopPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)languageConfig.getFileConfiguration().getString("Command.Island.Leave.Left.Broadcast.Message").replace("%player", player.getName())));
                    soundManager.playSound((CommandSender)loopPlayer, XSound.ENTITY_IRON_GOLEM_ATTACK, 5.0f, 5.0f);
                    if (!island.getRole(IslandRole.MEMBER).isEmpty() || !island.getRole(IslandRole.OPERATOR).isEmpty()) continue;
                    if (islandManager.getVisitorsAtIsland(island).isEmpty()) break;
                    scoreboardManager.updatePlayerScoreboardType(loopPlayer);
                    break;
                }
                messageManager.sendMessage((CommandSender)player, languageConfig.getFileConfiguration().getString("Command.Island.Leave.Left.Sender.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK, 5.0f, 5.0f);
                scoreboardManager.updatePlayerScoreboardType(player);
            }
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "leave";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Leave.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

