/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DemoteCommand
extends SubCommand {
    public DemoteCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (args.length == 1) {
            Island island = islandManager.getIsland((OfflinePlayer)player);
            if (island == null) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Owner.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            } else if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                Player targetPlayer = Bukkit.getPlayerExact((String)args[0]);
                if (targetPlayer == null) {
                    com.craftaro.skyblock.utils.player.OfflinePlayer offlinePlayer = new com.craftaro.skyblock.utils.player.OfflinePlayer(args[0]);
                    Set<UUID> islandMembers = island.getRole(IslandRole.MEMBER);
                    if (offlinePlayer.getUniqueId() != null && (islandMembers.contains(offlinePlayer.getUniqueId()) || island.getRole(IslandRole.OPERATOR).contains(offlinePlayer.getUniqueId()))) {
                        if (islandMembers.contains(offlinePlayer.getUniqueId())) {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Role.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        } else {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Demoted.Sender.Message").replace("%player", offlinePlayer.getName()));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                            island.removeRole(IslandRole.OPERATOR, offlinePlayer.getUniqueId());
                            island.setRole(IslandRole.MEMBER, offlinePlayer.getUniqueId());
                            island.save();
                        }
                    } else {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Member.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    }
                } else if (island.hasRole(IslandRole.MEMBER, targetPlayer.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, targetPlayer.getUniqueId())) {
                    if (island.hasRole(IslandRole.MEMBER, targetPlayer.getUniqueId())) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Role.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    } else {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Demoted.Sender.Message").replace("%player", targetPlayer.getName()));
                        messageManager.sendMessage((CommandSender)targetPlayer, configLoad.getString("Command.Island.Demote.Demoted.Target.Message"));
                        soundManager.playSound((CommandSender)player, XSound.ENTITY_IRON_GOLEM_ATTACK);
                        soundManager.playSound((CommandSender)targetPlayer, XSound.ENTITY_IRON_GOLEM_ATTACK);
                        island.removeRole(IslandRole.OPERATOR, targetPlayer.getUniqueId());
                        island.setRole(IslandRole.MEMBER, targetPlayer.getUniqueId());
                        island.save();
                    }
                } else {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Promote.Member.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                }
            } else {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Permission.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
            }
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Demote.Invalid.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "demote";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Demote.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

