/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.player.OfflinePlayer;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CurrentCommand
extends SubCommand {
    public CurrentCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        PlayerData playerData;
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (args.length > 0 && !args[0].equalsIgnoreCase(player.getName())) {
            if (args.length == 1) {
                Player targetPlayer = Bukkit.getPlayerExact((String)args[0]);
                if (targetPlayer == null) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Offline.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    return;
                }
                if (!targetPlayer.getName().equals(player.getName())) {
                    PlayerData playerData2 = playerDataManager.getPlayerData(targetPlayer);
                    if (playerData2.getIsland() == null) {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Island.None.Other.Message"));
                    } else {
                        String targetPlayerName = targetPlayer.getName();
                        targetPlayer = Bukkit.getServer().getPlayer(playerData2.getIsland());
                        String ownerPlayerName = targetPlayer == null ? new OfflinePlayer(playerData2.getIsland()).getName() : targetPlayer.getName();
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Island.Owner.Other.Message").replace("%target", targetPlayerName).replace("%owner", ownerPlayerName));
                    }
                    soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
                    return;
                }
            } else if (args.length > 1) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Invalid.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
        }
        if ((playerData = playerDataManager.getPlayerData(player)).getIsland() == null) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Island.None.Yourself.Message"));
        } else {
            Player targetPlayer = Bukkit.getServer().getPlayer(playerData.getIsland());
            String targetPlayerName = targetPlayer == null ? new OfflinePlayer(playerData.getIsland()).getName() : targetPlayer.getName();
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Current.Island.Owner.Yourself.Message").replace("%player", targetPlayerName));
        }
        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_YES);
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "current";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Current.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"cur"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

