/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.confirmation.Confirmation;
import com.craftaro.skyblock.cooldown.CooldownType;
import com.craftaro.skyblock.core.hooks.economies.Economy;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.scoreboard.ScoreboardManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.structure.Structure;
import com.craftaro.skyblock.structure.StructureManager;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfirmCommand
extends SubCommand {
    public ConfirmCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        StructureManager structureManager = this.plugin.getStructureManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        Economy economy = this.plugin.getEconomyManager().getEconomy();
        if (playerDataManager.hasPlayerData(player)) {
            PlayerData playerData = playerDataManager.getPlayerData(player);
            FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
            FileConfiguration configLoad = config.getFileConfiguration();
            if (playerData.getConfirmationTime() > 0) {
                Island island = islandManager.getIsland((OfflinePlayer)player);
                if (island == null) {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Owner.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                } else {
                    Confirmation confirmation = playerData.getConfirmation();
                    if (confirmation == Confirmation.OWNERSHIP || confirmation == Confirmation.RESET || confirmation == Confirmation.DELETION) {
                        if (island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
                            if (confirmation == Confirmation.OWNERSHIP) {
                                UUID targetPlayerUUID = playerData.getOwnership();
                                if (island.hasRole(IslandRole.MEMBER, targetPlayerUUID) || island.hasRole(IslandRole.OPERATOR, targetPlayerUUID)) {
                                    String targetPlayerName;
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Confirmed.Message"));
                                    Player targetPlayer = Bukkit.getServer().getPlayer(targetPlayerUUID);
                                    if (targetPlayer == null) {
                                        targetPlayerName = new com.craftaro.skyblock.utils.player.OfflinePlayer(targetPlayerUUID).getName();
                                    } else {
                                        targetPlayerName = targetPlayer.getName();
                                        messageManager.sendMessage((CommandSender)targetPlayer, configLoad.getString("Command.Island.Confirmation.Ownership.Assigned.Message"));
                                        soundManager.playSound((CommandSender)targetPlayer, XSound.BLOCK_ANVIL_USE);
                                    }
                                    for (Player all : Bukkit.getOnlinePlayers()) {
                                        if (!island.hasRole(IslandRole.MEMBER, all.getUniqueId()) && !island.hasRole(IslandRole.OPERATOR, all.getUniqueId()) && !island.hasRole(IslandRole.OWNER, all.getUniqueId()) && !island.hasRole(IslandRole.OWNER, all.getUniqueId()) || all.getUniqueId().equals(targetPlayerUUID)) continue;
                                        all.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Command.Island.Ownership.Assigned.Broadcast.Message").replace("%player", targetPlayerName)));
                                        soundManager.playSound((CommandSender)all, XSound.BLOCK_ANVIL_USE);
                                    }
                                    playerData.setConfirmation(null);
                                    playerData.setConfirmationTime(0);
                                    islandManager.giveOwnership(island, Bukkit.getServer().getOfflinePlayer(targetPlayerUUID));
                                    this.plugin.getCooldownManager().createPlayer(CooldownType.OWNERSHIP, Bukkit.getServer().getOfflinePlayer(island.getOwnerUUID()));
                                } else {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Ownership.Member.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                }
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> scoreboardManager.updatePlayerScoreboardType(player));
                            } else if (confirmation == Confirmation.RESET) {
                                playerData.setConfirmation(null);
                                playerData.setConfirmationTime(0);
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> scoreboardManager.updatePlayerScoreboardType(player));
                            } else if (confirmation == Confirmation.DELETION) {
                                if (island.getStatus() == IslandStatus.OPEN) {
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Deletion.Open.Message"));
                                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                } else {
                                    Structure structure;
                                    double deletionCost;
                                    Location spawnLocation = LocationUtil.getSpawnLocation();
                                    if (spawnLocation != null && islandManager.isLocationAtIsland(island, spawnLocation)) {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Deletion.Spawn.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                        return;
                                    }
                                    if (economy != null && economy.isEnabled() && island.getStructure() != null && !island.getStructure().isEmpty() && structureManager.containsStructure(island.getStructure()) && (deletionCost = (structure = structureManager.getStructure(island.getStructure())).getDeletionCost()) != 0.0) {
                                        if (economy.hasBalance((OfflinePlayer)player, deletionCost)) {
                                            economy.withdrawBalance((OfflinePlayer)player, deletionCost);
                                        } else {
                                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Deletion.Money.Message").replace("%cost", "" + deletionCost));
                                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                                            return;
                                        }
                                    }
                                    playerData.setConfirmation(null);
                                    playerData.setConfirmationTime(0);
                                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Confirmed.Message"));
                                    for (Player all : Bukkit.getOnlinePlayers()) {
                                        if (!island.hasRole(IslandRole.MEMBER, all.getUniqueId()) && !island.hasRole(IslandRole.OPERATOR, all.getUniqueId())) continue;
                                        all.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Command.Island.Confirmation.Deletion.Broadcast.Message")));
                                        soundManager.playSound((CommandSender)all, XSound.ENTITY_GENERIC_EXPLODE, 10.0f, 10.0f);
                                    }
                                    if (islandManager.deleteIsland(island, false)) {
                                        island.setDeleted(true);
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Deletion.Sender.Message"));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_GENERIC_EXPLODE, 10.0f, 10.0f);
                                    } else {
                                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Deletion.Sender.MaxDeletionMessage"));
                                        soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                    }
                                }
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> scoreboardManager.updatePlayerScoreboardType(player));
                            }
                        } else {
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Role.Message"));
                            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                        }
                    } else {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Specified.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    }
                }
            } else {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Confirmation.Pending.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            }
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "confirm";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Confirmation.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"confirmation"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

