/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandStatus;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CloseCommand
extends SubCommand {
    public CloseCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (island == null) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Close.Owner.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else if (island.hasRole(IslandRole.OWNER, player.getUniqueId()) || island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && this.plugin.getPermissionManager().hasPermission(island, "Visitor", IslandRole.OPERATOR)) {
            if (island.getStatus() == IslandStatus.OPEN || island.getStatus() == IslandStatus.WHITELISTED) {
                islandManager.closeIsland(island);
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Close.Closed.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_WOODEN_DOOR_CLOSE);
            } else {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Close.Already.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            }
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Close.Permission.Message"));
            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "close";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Close.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"lock"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

