/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.challenge.FabledChallenge;
import com.craftaro.skyblock.challenge.challenge.Challenge;
import com.craftaro.skyblock.challenge.challenge.ChallengeCategory;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ChallengeCommand
extends SubCommand {
    public ChallengeCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        FabledChallenge fabledChallenge = this.plugin.getFabledChallenge();
        IslandManager islandManager = this.plugin.getIslandManager();
        FileManager.Config langConfig = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration langConfigLoad = langConfig.getFileConfiguration();
        if (!this.plugin.getConfiguration().getBoolean("Island.Challenge.Enable")) {
            messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.Disabled.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            return;
        }
        if (args.length == 0) {
            if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland") && islandManager.getIsland((OfflinePlayer)player) == null) {
                messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.NoIsland.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
            ChallengeCategory cc = fabledChallenge.getChallengeManager().getChallenge(1);
            if (cc == null) {
                messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.NotFound.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                return;
            }
            fabledChallenge.openChallengeInventory(player, fabledChallenge.getChallengeManager().getChallenge(1));
            return;
        }
        if (args.length == 2) {
            int cId;
            int ccId;
            try {
                ccId = Integer.parseInt(args[0]);
                cId = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.Invalid.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_HURT);
                return;
            }
            ChallengeCategory cc = fabledChallenge.getChallengeManager().getChallenge(ccId);
            if (cc == null) {
                messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.CategoryNotFound.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_HURT);
                return;
            }
            Challenge c = cc.getChallenge(cId);
            if (c == null) {
                messageManager.sendMessage((CommandSender)player, langConfigLoad.getString("Command.Island.Challenge.ChallengeNotFound.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_HURT);
                return;
            }
            if (fabledChallenge.getPlayerManager().doChallenge(player, c)) {
                soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
            } else {
                soundManager.playSound((CommandSender)player, XSound.BLOCK_GLASS_BREAK);
            }
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "challenge";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Challenge.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"c", "challenges"};
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

