/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.biome.BiomeManager;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.gui.biome.GuiBiome;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class BiomeCommand
extends SubCommand {
    public BiomeCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        BiomeManager biomeManager = this.plugin.getBiomeManager();
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        Island island = islandManager.getIsland((OfflinePlayer)player);
        if (island == null) {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Biome.Owner.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        } else if (island.hasRole(IslandRole.OPERATOR, player.getUniqueId()) && this.plugin.getPermissionManager().hasPermission(island, "Biome", IslandRole.OPERATOR) || island.hasRole(IslandRole.OWNER, player.getUniqueId())) {
            if (biomeManager.isUpdating(island)) {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Biome.InProgress.Message"));
                soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
            } else {
                this.plugin.getGuiManager().showGUI(player, new GuiBiome(this.plugin, player, island, IslandWorld.NORMAL, null, false));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_CHEST_OPEN);
            }
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Biome.Permission.Message"));
            soundManager.playSound((CommandSender)player, XSound.ENTITY_VILLAGER_NO);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "biome";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Biome.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

