/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.player.PlayerIslandJoinEvent;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.invite.Invite;
import com.craftaro.skyblock.invite.InviteManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandRole;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.scoreboard.ScoreboardManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AcceptCommand
extends SubCommand {
    public AcceptCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        ScoreboardManager scoreboardManager = this.plugin.getScoreboardManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        PlayerData playerData = playerDataManager.getPlayerData(player);
        FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (args.length == 1) {
            InviteManager inviteManager = this.plugin.getInviteManager();
            if (inviteManager.hasInvite(player.getUniqueId())) {
                Invite invite = inviteManager.getInvite(player.getUniqueId());
                String playerName = args[0];
                if (invite.getSenderName().equalsIgnoreCase(playerName)) {
                    inviteManager.removeInvite(player.getUniqueId());
                    if (islandManager.getIsland((OfflinePlayer)player) == null) {
                        Island island;
                        boolean unloadIsland = false;
                        if (islandManager.containsIsland(invite.getOwnerUUID())) {
                            island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(invite.getOwnerUUID()));
                        } else {
                            islandManager.loadIsland(Bukkit.getServer().getOfflinePlayer(invite.getOwnerUUID()));
                            island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(invite.getOwnerUUID()));
                            unloadIsland = true;
                        }
                        PlayerIslandJoinEvent islandJoinEvent = new PlayerIslandJoinEvent(player, island.getAPIWrapper());
                        Bukkit.getServer().getPluginManager().callEvent((Event)islandJoinEvent);
                        if (islandJoinEvent.isCancelled()) {
                            if (unloadIsland) {
                                islandManager.unloadIsland(island, null);
                            }
                        } else {
                            Player targetPlayer = Bukkit.getServer().getPlayer(invite.getSenderUUID());
                            if (targetPlayer != null) {
                                messageManager.sendMessage((CommandSender)targetPlayer, configLoad.getString("Command.Island.Accept.Accepted.Target.Message").replace("%player", player.getName()));
                                soundManager.playSound((CommandSender)targetPlayer, XSound.ENTITY_PLAYER_LEVELUP);
                            }
                            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Accept.Accepted.Sender.Message").replace("%player", invite.getSenderName()));
                            soundManager.playSound((CommandSender)player, XSound.ENTITY_PLAYER_LEVELUP);
                            playerData.setPlaytime(0);
                            playerData.setOwner(invite.getOwnerUUID());
                            playerData.setMemberSince(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
                            playerData.save();
                            island.setRole(IslandRole.MEMBER, player.getUniqueId());
                            island.save();
                            if (island.getRole(IslandRole.MEMBER).size() + island.getRole(IslandRole.OPERATOR).size() + 1 >= island.getMaxMembers(player)) {
                                Map<UUID, Invite> invites = inviteManager.getInvites();
                                for (UUID inviteList : invites.keySet()) {
                                    Invite targetInvite = invites.get(inviteList);
                                    if (!targetInvite.getOwnerUUID().equals(invite.getOwnerUUID())) continue;
                                    inviteManager.removeInvite(inviteList);
                                    Player targetInvitePlayer = Bukkit.getServer().getPlayer(inviteList);
                                    if (targetInvitePlayer == null) continue;
                                    targetInvitePlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Command.Island.Accept.Capacity.Broadcast.Message").replace("%player", targetInvite.getSenderName())));
                                    soundManager.playSound((CommandSender)targetInvitePlayer, XSound.ENTITY_IRON_GOLEM_ATTACK);
                                }
                            }
                            this.plugin.getVisitManager().getIsland(invite.getOwnerUUID()).removeVoter(player.getUniqueId());
                            for (Player loopPlayer : Bukkit.getOnlinePlayers()) {
                                if (loopPlayer.getUniqueId().equals(player.getUniqueId()) || !playerDataManager.hasPlayerData(loopPlayer) || (playerData = playerDataManager.getPlayerData(loopPlayer)).getOwner() == null || !playerData.getOwner().equals(island.getOwnerUUID())) continue;
                                loopPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)configLoad.getString("Command.Island.Accept.Accepted.Broadcast.Message").replace("%player", player.getName())));
                                soundManager.playSound((CommandSender)loopPlayer, XSound.ENTITY_FIREWORK_ROCKET_BLAST);
                                if (island.getRole(IslandRole.MEMBER).size() != 1 || !island.getRole(IslandRole.OPERATOR).isEmpty()) continue;
                                scoreboardManager.updatePlayerScoreboardType(loopPlayer);
                            }
                            scoreboardManager.updatePlayerScoreboardType(player);
                        }
                    } else {
                        messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Accept.Owner.Message"));
                        soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    }
                } else {
                    messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Accept.Invited.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                }
            } else {
                messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Accept.Invite.Message"));
                soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
            }
        } else {
            messageManager.sendMessage((CommandSender)player, configLoad.getString("Command.Island.Accept.Invalid.Message"));
            soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "accept";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Accept.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }
}

