/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.stackable.Stackable;
import com.craftaro.skyblock.stackable.StackableManager;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class StackableCommand
extends SubCommand {
    public StackableCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        MessageManager messageManager = this.plugin.getMessageManager();
        if (args.length == 0) {
            player.sendMessage(StringUtil.color("&e/island admin stackable setsize <size> &7- &f&osets the target block's stack size if applicable"));
            return;
        }
        FileConfiguration messageConfig = this.plugin.getFileManager().getConfig(new File(this.plugin.getDataFolder(), "language.yml")).getFileConfiguration();
        if (args[0].equalsIgnoreCase("setsize")) {
            int oldSize;
            XMaterial type;
            int amount;
            if (args.length == 1) {
                messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Admin.Stackable.Setsize.No-Arguments"));
                return;
            }
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Admin.Stackable.Setsize.Invalid-Number").replace("%number%", args[1]));
                return;
            }
            Block block = player.getTargetBlock(null, 6);
            if (block == null) {
                messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Admin.Stackable.Target.None"));
                return;
            }
            StackableManager stackableManager = this.plugin.getStackableManager();
            if (!stackableManager.isStackableMaterial(type = CompatibleMaterial.getMaterial(block.getType()).get())) {
                messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Admin.Stackable.Target.Unstackable"));
                return;
            }
            Location loc = block.getLocation();
            Stackable stack = stackableManager.getStack(loc, type);
            if (amount <= 1) {
                messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Admin.Stackable.Target.Remove-Stack"));
                if (stack != null) {
                    stackableManager.removeStack(stack);
                }
                return;
            }
            if (stack == null) {
                stack = new Stackable(loc, type);
                stackableManager.addStack(stack);
                oldSize = 0;
            } else {
                oldSize = stack.getSize();
            }
            stack.setSize(amount);
            String input = messageConfig.getString("Command.Island.Admin.Stackable.Setsize.Success");
            input = input.replace("%old_size%", Integer.toString(oldSize));
            input = input.replace("%new_size%", Integer.toString(amount));
            messageManager.sendMessage((CommandSender)player, input);
        } else {
            messageManager.sendMessage((CommandSender)player, messageConfig.getString("Command.Island.Argument.Unrecognised.Message"));
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "stackable";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Admin.Stackable.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"stackables"};
    }

    @Override
    public String[] getArguments() {
        return new String[]{"setsize"};
    }
}

