/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.biome.BiomeManager;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.CompatibleBiome;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.StringUtil;
import com.craftaro.skyblock.utils.player.OfflinePlayer;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class SetBiomeCommand
extends SubCommand {
    public SetBiomeCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        this.onCommand((CommandSender)player, args);
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    public void onCommand(CommandSender sender, String[] args) {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        BiomeManager biomeManager = this.plugin.getBiomeManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager fileManager = this.plugin.getFileManager();
        FileManager.Config config = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration configLoad = config.getFileConfiguration();
        if (args.length >= 2) {
            String biomeName = args[1].toUpperCase().trim();
            Enum world = null;
            if (args.length > 2) {
                String worldName = args[2].toUpperCase().trim();
                for (Enum enum_ : IslandWorld.values()) {
                    if (!((IslandWorld)enum_).getFriendlyName().equalsIgnoreCase(worldName)) continue;
                    world = enum_;
                }
            }
            if (world == null) {
                world = IslandWorld.NORMAL;
            }
            Enum biome = null;
            for (Enum enum_ : CompatibleBiome.values()) {
                if (!((CompatibleBiome)enum_).isCompatible() || !enum_.name().equals(biomeName)) continue;
                biome = enum_;
                break;
            }
            if (biome != null) {
                String targetPlayerName;
                UUID islandOwnerUUID;
                Player targetPlayer = Bukkit.getPlayerExact((String)args[0]);
                if (targetPlayer == null) {
                    OfflinePlayer offlinePlayer = new OfflinePlayer(args[0]);
                    islandOwnerUUID = offlinePlayer.getOwner();
                    targetPlayerName = offlinePlayer.getName();
                } else {
                    islandOwnerUUID = playerDataManager.getPlayerData(targetPlayer).getOwner();
                    targetPlayerName = targetPlayer.getName();
                }
                if (islandOwnerUUID == null) {
                    messageManager.sendMessage(sender, configLoad.getString("Command.Island.Admin.SetBiome.Island.Owner.Message"));
                    soundManager.playSound(sender, XSound.ENTITY_VILLAGER_NO);
                } else {
                    if (islandManager.containsIsland(islandOwnerUUID)) {
                        Island island = islandManager.getIsland(Bukkit.getServer().getOfflinePlayer(islandOwnerUUID));
                        biomeManager.setBiome(island, (IslandWorld)world, (CompatibleBiome)biome, null);
                        if (world == IslandWorld.NORMAL) {
                            island.setBiome(((CompatibleBiome)biome).getBiome());
                        }
                    } else {
                        islandManager.loadIsland(Bukkit.getOfflinePlayer((UUID)islandOwnerUUID));
                        Island island = islandManager.getIsland(Bukkit.getOfflinePlayer((UUID)islandOwnerUUID));
                        if (island == null) {
                            messageManager.sendMessage(sender, configLoad.getString("Command.Island.Admin.SetBiome.Island.Data.Message"));
                            soundManager.playSound(sender, XSound.BLOCK_ANVIL_LAND);
                        } else {
                            Enum finalBiome = biome;
                            Enum finalWorld = world;
                            biomeManager.setBiome(island, (IslandWorld)world, (CompatibleBiome)biome, () -> SetBiomeCommand.lambda$onCommand$0((IslandWorld)finalWorld, island, (CompatibleBiome)finalBiome));
                        }
                    }
                    messageManager.sendMessage(sender, configLoad.getString("Command.Island.Admin.SetBiome.Set.Message").replace("%player", targetPlayerName).replace("%biome", StringUtil.capitalizeWord(((CompatibleBiome)biome).getBiome().name().replaceAll("_", " "))));
                    soundManager.playSound(sender, XSound.BLOCK_NOTE_BLOCK_PLING);
                }
            } else {
                messageManager.sendMessage(sender, configLoad.getString("Command.Island.Admin.SetBiome.InvalidBiome.Message"));
                soundManager.playSound(sender, XSound.BLOCK_ANVIL_LAND);
            }
        } else {
            messageManager.sendMessage(sender, configLoad.getString("Command.Island.Admin.SetBiome.Invalid.Message"));
            soundManager.playSound(sender, XSound.BLOCK_ANVIL_LAND);
        }
    }

    @Override
    public String getName() {
        return "setbiome";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Admin.SetBiome.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String[] getArguments() {
        return new String[0];
    }

    private static /* synthetic */ void lambda$onCommand$0(IslandWorld finalWorld, Island island, CompatibleBiome finalBiome) {
        if (finalWorld == IslandWorld.NORMAL) {
            island.setBiome(finalBiome.getBiome());
        }
    }
}

