/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.command.commands.admin;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.command.SubCommand;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandManager;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.playerdata.PlayerData;
import com.craftaro.skyblock.playerdata.PlayerDataManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.utils.player.OfflinePlayer;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ChatSpyCommand
extends SubCommand {
    public ChatSpyCommand(SkyBlock plugin) {
        super(plugin);
    }

    @Override
    public void onCommandByPlayer(Player player, String[] args) {
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        MessageManager messageManager = this.plugin.getMessageManager();
        IslandManager islandManager = this.plugin.getIslandManager();
        FileManager fileManager = this.plugin.getFileManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileManager.Config language = fileManager.getConfig(new File(this.plugin.getDataFolder(), "language.yml"));
        FileConfiguration languageLoad = language.getFileConfiguration();
        PlayerData playerData = playerDataManager.getPlayerData(player);
        if (args.length < 1) {
            this.toggleSpy(player, messageManager, languageLoad, playerData);
        } else {
            switch (args[0].toLowerCase()) {
                case "toggle": {
                    this.toggleSpy(player, messageManager, languageLoad, playerData);
                    break;
                }
                case "global": {
                    if (!playerData.isGlobalChatSpy()) {
                        playerData.enableGlobalChatSpy();
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.GlobalEnabled.Message"));
                        break;
                    }
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.GlobalAlreadyEnabled.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case "add": {
                    if (args.length == 2) {
                        OfflinePlayer offlinePlayer = new OfflinePlayer(args[1]);
                        Island island = islandManager.getIslandByOwner(offlinePlayer.getBukkitOfflinePlayer());
                        if (island != null) {
                            playerData.addChatSpyIsland(island);
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.Add.Message").replace("%owner", new OfflinePlayer(island.getOwnerUUID()).getName()));
                            break;
                        }
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.NullIsland.Message"));
                        break;
                    }
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.InvalidArgNumber.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case "remove": {
                    if (args.length == 2) {
                        OfflinePlayer offlinePlayer = new OfflinePlayer(args[1]);
                        Island island = islandManager.getIslandByOwner(offlinePlayer.getBukkitOfflinePlayer());
                        if (island != null) {
                            playerData.removeChatSpyIsland(island);
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.Remove.Message").replace("%owner", new OfflinePlayer(island.getOwnerUUID()).getName()));
                            break;
                        }
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.NullIsland.Message"));
                        break;
                    }
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.InvalidArgNumber.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                    break;
                }
                case "list": {
                    Set<UUID> uuidSet = playerData.getChatSpyIslands();
                    if (!uuidSet.isEmpty()) {
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.List.Start.Message"));
                        for (UUID uuid : uuidSet) {
                            messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.List.List.Message").replace("%owner", new OfflinePlayer(uuid).getName()));
                        }
                        messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.List.End.Message"));
                        break;
                    }
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.List.Empty.Message"));
                    break;
                }
                default: {
                    messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.InvalidArgNumber.Message"));
                    soundManager.playSound((CommandSender)player, XSound.BLOCK_ANVIL_LAND);
                }
            }
        }
    }

    private void toggleSpy(Player player, MessageManager messageManager, FileConfiguration languageLoad, PlayerData playerData) {
        if (playerData != null) {
            if (playerData.isChatSpy()) {
                playerData.setChatSpy(false);
                messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.Disabled.Message"));
            } else {
                playerData.setChatSpy(true);
                messageManager.sendMessage((CommandSender)player, languageLoad.getString("Command.Island.Admin.ChatSpy.Enabled.Message"));
            }
        }
    }

    @Override
    public void onCommandByConsole(ConsoleCommandSender sender, String[] args) {
        sender.sendMessage("SkyBlock | Error: You must be a player to perform that command.");
    }

    @Override
    public String getName() {
        return "chatspy";
    }

    @Override
    public String getInfoMessagePath() {
        return "Command.Island.Admin.ChatSpy.Info.Message";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"spychat", "spy"};
    }

    @Override
    public String[] getArguments() {
        return new String[]{"toggle", "global", "add", "remove", "list"};
    }
}

