/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.challenge.player;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.challenge.challenge.Challenge;
import com.craftaro.skyblock.challenge.challenge.ChallengeCategory;
import com.craftaro.skyblock.challenge.challenge.Peer;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerManager {
    private final SkyBlock plugin;
    private final HashMap<UUID, HashMap<Challenge, Integer>> islands;
    private final File playersDirectory;

    public PlayerManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.islands = new HashMap();
        this.playersDirectory = new File(plugin.getDataFolder(), "challenge-data");
        if (!this.playersDirectory.exists()) {
            this.playersDirectory.mkdirs();
        }
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getServer().getOnlinePlayers().stream().map(Entity::getUniqueId).forEach(this::loadPlayer));
    }

    public HashMap<Challenge, Integer> getPlayer(UUID uuid) {
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", false)) {
            Island is;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                player = Bukkit.getOfflinePlayer((UUID)uuid);
            }
            if ((is = this.plugin.getIslandManager().getIsland((OfflinePlayer)player)) != null) {
                uuid = is.getOwnerUUID();
            }
        }
        return this.islands.get(uuid);
    }

    public void loadPlayer(UUID uuid) {
        Island is;
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", true) && (is = this.plugin.getIslandManager().getIsland(Bukkit.getOfflinePlayer((UUID)uuid))) != null) {
            uuid = is.getOwnerUUID();
        }
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.playersDirectory, FastUUID.toString(uuid) + ".yml"));
        FileConfiguration fileConfig = config.getFileConfiguration();
        HashMap<Challenge, Integer> challenges = new HashMap<Challenge, Integer>();
        ConfigurationSection section = fileConfig.getConfigurationSection("challenges");
        Set strs = section != null ? section.getKeys(false) : new HashSet();
        for (String k : strs) {
            ConfigurationSection section2;
            int id = fileConfig.getInt("challenges." + k + ".id");
            ChallengeCategory cc = this.plugin.getFabledChallenge().getChallengeManager().getChallenge(id);
            if (cc == null || (section2 = fileConfig.getConfigurationSection("challenges." + k + ".challenges")) == null) continue;
            for (String d : section2.getKeys(false)) {
                String key = "challenges." + k + ".challenges." + d;
                int cId = fileConfig.getInt(key + ".id");
                int count = fileConfig.getInt(key + ".count");
                Challenge c = cc.getChallenge(cId);
                if (c == null) continue;
                challenges.put(c, count);
            }
        }
        this.islands.put(uuid, challenges);
    }

    public void unloadPlayer(UUID uuid) {
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", false)) {
            Island is;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                player = Bukkit.getOfflinePlayer((UUID)uuid);
            }
            if ((is = this.plugin.getIslandManager().getIsland((OfflinePlayer)player)) != null) {
                if (!this.plugin.getIslandManager().getMembersOnline(is).isEmpty()) {
                    return;
                }
                uuid = is.getOwnerUUID();
            }
        }
        this.islands.remove(uuid);
        this.plugin.getFileManager().unloadConfig(new File(this.playersDirectory, FastUUID.toString(uuid) + ".yml"));
    }

    public boolean canDoChallenge(Player p, Challenge c) {
        HashMap<Challenge, Integer> done;
        Island is;
        if (c == null) {
            return false;
        }
        UUID uuid = p.getUniqueId();
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", true) && (is = this.plugin.getIslandManager().getIsland(Bukkit.getOfflinePlayer((UUID)uuid))) != null) {
            uuid = is.getOwnerUUID();
        }
        if ((done = this.islands.get(uuid)) == null) {
            this.loadPlayer(uuid);
            done = this.islands.get(uuid);
        }
        int count = done.getOrDefault(c, 0);
        if (c.getMaxTimes() != 0 && count >= c.getMaxTimes()) {
            return false;
        }
        for (Peer<Challenge.Type, Object> peer : c.getRequires()) {
            if (peer.getKey().has(p, peer.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean doChallenge(Player p, Challenge c) {
        Island is;
        if (!this.canDoChallenge(p, c)) {
            return false;
        }
        UUID uuid = p.getUniqueId();
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", true) && (is = this.plugin.getIslandManager().getIsland(Bukkit.getOfflinePlayer((UUID)uuid))) != null) {
            uuid = is.getOwnerUUID();
        }
        HashMap<Challenge, Integer> done = this.islands.get(uuid);
        int count = done.getOrDefault(c, 0);
        done.put(c, count + 1);
        this.addChallenge(uuid, c);
        for (Peer<Challenge.Type, Object> peer : c.getRequires()) {
            peer.getKey().executeRequire(p, peer.getValue());
        }
        for (Peer<Challenge.Type, Object> peer : c.getRewards()) {
            peer.getKey().executeReward(p, peer.getValue());
        }
        String broadcast = this.plugin.formatText(this.plugin.getLanguage().getString("Challenge.Broadcast"));
        if (c.isShowInChat()) {
            Bukkit.broadcastMessage((String)broadcast.replace("%player", p.getName()).replace("%challenge", c.getName()).replace("%amount", Integer.toString(count + 1)).replace("%max", Integer.toString(c.getMaxTimes())));
        }
        return true;
    }

    public void addChallenge(UUID uuid, Challenge c) {
        Island is;
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", true) && (is = this.plugin.getIslandManager().getIsland(Bukkit.getOfflinePlayer((UUID)uuid))) != null) {
            uuid = is.getOwnerUUID();
        }
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.playersDirectory, FastUUID.toString(uuid) + ".yml"));
        FileConfiguration fileConfig = config.getFileConfiguration();
        int ccId = c.getCategory().getId();
        int cId = c.getId();
        int count = 1;
        if (fileConfig.contains("challenges." + ccId + ".challenges." + cId + ".count")) {
            count = fileConfig.getInt("challenges." + ccId + ".challenges." + cId + ".count") + 1;
        }
        fileConfig.set("challenges." + ccId + ".id", (Object)ccId);
        fileConfig.set("challenges." + ccId + ".challenges." + cId + ".id", (Object)cId);
        fileConfig.set("challenges." + ccId + ".challenges." + cId + ".count", (Object)count);
        try {
            fileConfig.save(new File(this.playersDirectory, FastUUID.toString(uuid) + ".yml"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getChallengeCount(UUID uuid, Challenge c) {
        Island is;
        HashMap<Challenge, Integer> challenges = this.islands.get(uuid);
        if (challenges != null) {
            return challenges.getOrDefault(c, 0);
        }
        if (this.plugin.getConfiguration().getBoolean("Island.Challenge.PerIsland", true) && (is = this.plugin.getIslandManager().getIsland(Bukkit.getOfflinePlayer((UUID)uuid))) != null) {
            uuid = is.getOwnerUUID();
        }
        FileManager.Config config = this.plugin.getFileManager().getConfig(new File(this.playersDirectory, FastUUID.toString(uuid) + ".yml"));
        FileConfiguration fileConfig = config.getFileConfiguration();
        int ccId = c.getCategory().getId();
        int cId = c.getId();
        if (!fileConfig.contains("challenges." + ccId + ".challenges." + cId + ".count")) {
            return 0;
        }
        return fileConfig.getInt("challenges." + ccId + ".challenges." + cId + ".count");
    }
}

