/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.challenge.challenge;

import com.craftaro.skyblock.challenge.challenge.Challenge;
import com.craftaro.skyblock.challenge.challenge.ItemChallenge;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ChallengeCategory {
    private final int id;
    private final String name;
    private final HashMap<Integer, Challenge> challenges;

    public ChallengeCategory(int id, String name, FileConfiguration config) {
        this.id = id;
        this.name = name;
        this.challenges = new HashMap();
        this.loadChallenges(config);
    }

    private void loadChallenges(FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("challenges." + this.id + ".challenges");
        if (section == null) {
            return;
        }
        Set keys = section.getKeys(false);
        for (String k : keys) {
            String strItem;
            int maxTimes;
            List<String> reward;
            List<String> require;
            String name;
            int id;
            String key;
            block9: {
                key = "challenges." + this.id + ".challenges." + k;
                id = config.getInt(key + ".id");
                if (id == 0) {
                    throw new IllegalArgumentException("Invalid id at category " + this.name + "(" + this.id + ") at challenge " + this.name + "(" + id + ")");
                }
                name = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(key + ".name"));
                require = this.toColor(config.getStringList(key + ".require"));
                reward = this.toColor(config.getStringList(key + ".reward"));
                maxTimes = 0;
                try {
                    Integer.parseInt(config.getString(key + ".maxtimes", "unlimited"));
                    maxTimes = config.getInt(key + ".maxtimes");
                }
                catch (NumberFormatException ignored) {
                    if (!config.getString(key + ".maxtimes", "unlimited").equalsIgnoreCase("unlimited")) break block9;
                    maxTimes = Integer.MAX_VALUE;
                }
            }
            boolean showInChat = config.getBoolean(key + ".showInChat");
            boolean show = config.getBoolean(key + ".item.show");
            int row = show ? config.getInt(key + ".item.row") : 0;
            int col = show ? config.getInt(key + ".item.col") : 0;
            String string = strItem = show ? config.getString(key + ".item.item") : "AIR";
            if (strItem == null) {
                strItem = "AIR";
            }
            int amount = show ? config.getInt(key + ".item.amount") : 0;
            ArrayList<String> lore = show ? this.toColor(config.getStringList(key + ".item.lore")) : new ArrayList<String>();
            try {
                Optional<XMaterial> compatibleMaterial = CompatibleMaterial.getMaterial(strItem);
                if (!compatibleMaterial.isPresent()) {
                    throw new IllegalArgumentException("Item " + strItem + " isn't a correct material");
                }
                ItemChallenge ic = new ItemChallenge(show, row, col, compatibleMaterial.get(), amount, lore);
                Challenge c = new Challenge(this, id, name, maxTimes, showInChat, require, reward, ic);
                this.challenges.put(id, c);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Exception at category " + this.name.replace("&", "") + "(" + this.id + ") at challenge " + name.replace("&", "") + "(" + id + "): " + ex.getMessage());
            }
        }
        Bukkit.getConsoleSender().sendMessage("[FabledSkyBlock] " + ChatColor.GREEN + "Category " + this.name + ChatColor.GREEN + " loaded with " + ChatColor.GOLD + this.challenges.size() + ChatColor.GREEN + " challenges");
    }

    private List<String> toColor(List<String> list) {
        ArrayList<String> copy = new ArrayList<String>();
        if (list == null) {
            return copy;
        }
        for (String str : list) {
            copy.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
        }
        return copy;
    }

    public Challenge getChallenge(int id) {
        return this.challenges.get(id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<Integer, Challenge> getChallenges() {
        return this.challenges;
    }
}

